/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b.socket;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.driver.comm.b2b.InvokeMessage;
import com.wm.driver.comm.b2b.WmMessage;
import com.wm.driver.comm.b2b.socket.SocketLink;
import com.wm.io.comm.CommException;
import com.wm.io.comm.IMessage;
import com.wm.util.JournalLogger;
import com.wm.util.comm.LinkParameters;
import com.wm.util.text.UUID;
import java.net.Socket;
import java.util.Properties;

public class SessionSocketLink
extends SocketLink {
    public static final boolean log = true;
    private String id;
    private String sessionId;
    private boolean needPing;
    private Pinger pinger;

    public SessionSocketLink(LinkParameters lp) throws CommException {
        super(lp);
        this.id = "sessionsock:" + UUID.generate();
        this.pinger = new Pinger(120000L);
        this.pinger.start();
    }

    public SessionSocketLink(Socket s, LinkParameters lp) throws CommException {
        super(s, lp);
    }

    private IData createHeader() {
        IData hdr = IDataFactory.create();
        IDataCursor cr = hdr.getCursor();
        cr.insertAfter("Session", "false");
        cr.insertAfter("Authorization", this.basicAuth);
        if (this.sessionId != null) {
            cr.insertAfter("Cookie", this.sessionId);
        }
        cr.destroy();
        return hdr;
    }

    public synchronized void send(String uuid, String cmd, Properties p, IData data) throws CommException {
        IData hdr = this.createHeader();
        WmMessage requestMsg = WmMessage.createMessage(uuid, cmd, hdr, data, 3, p);
        this.send(requestMsg);
    }

    public IMessage receive(boolean poll) throws CommException {
        IData hdr;
        WmMessage result = (WmMessage)super.receive(poll);
        if (result != null && (hdr = result.getHeader()) != null) {
            String newSessionId = null;
            IDataCursor cr = hdr.getCursor();
            if (cr.first("Set-Cookie")) {
                newSessionId = this.getCookieId((String)cr.getValue());
            }
            if (newSessionId != null && !newSessionId.equals(this.sessionId)) {
                this.sessionId = newSessionId;
            }
            this.setNeedPing(false);
        }
        return result;
    }

    public void disconnect() {
        try {
            String uuid = UUID.generate();
            WmMessage requestMsg = InvokeMessage.createMessage(uuid, "wm.server:disconnect", null, null, 3, null);
            this.send(requestMsg);
            this.sessionId = null;
            if (this.pinger != null) {
                this.pinger.interrupt();
            }
            this.pinger = null;
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void setNeedPing(boolean ping) {
        this.needPing = ping;
    }

    private synchronized void pingServer() {
        if (!this.needPing) {
            return;
        }
        try {
            String uuid = UUID.generate();
            WmMessage requestMsg = WmMessage.createMessage(uuid, "wm.server:ping", null, null, 3, null);
            this.send(requestMsg);
        }
        catch (Exception e) {
            JournalLogger.logDebugPlus(1, 3, 36);
        }
        this.setNeedPing(true);
    }

    private String getCookieId(String cookie) {
        if (cookie == null) {
            return null;
        }
        int len = cookie.indexOf("ssnid=");
        if (len >= 0) {
            int len2 = cookie.indexOf(";", len + 1);
            return cookie.substring(len + 6, len2);
        }
        return null;
    }

    class Pinger
    extends Thread {
        long timeout;

        public Pinger() {
            this(120000L);
        }

        public Pinger(long timeout) {
            this.timeout = timeout;
            System.out.println("Timeout Callback time set to " + timeout + " ms");
        }

        public void run() {
            try {
                while (true) {
                    Pinger.sleep(this.timeout);
                    SessionSocketLink.this.pingServer();
                    SessionSocketLink.this.setNeedPing(true);
                }
            }
            catch (InterruptedException e) {
                System.out.println("Pinger Interrupted");
                return;
            }
        }
    }
}

