/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b.http;

import com.wm.data.IData;
import com.wm.driver.comm.b2b.InvokeMessage;
import com.wm.driver.comm.b2b.WmMessage;
import com.wm.driver.comm.b2b.http.HTTPLink;
import com.wm.io.comm.CommException;
import com.wm.net.HttpURLConnection;
import com.wm.net.Net504Exception;
import com.wm.security.TrustManager;
import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.IDataBinCoder;
import com.wm.util.comm.LinkParameters;
import com.wm.util.text.UUID;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SessionHTTPLink
extends HTTPLink {
    private String id = "session-http:" + UUID.generate();
    private String sessionId;
    private boolean needPing;
    private Pinger pinger;

    public SessionHTTPLink(LinkParameters linkInfo) throws CommException {
        super(linkInfo);
        WmMessage replyMsg = this.transportMsg(WmMessage.createMessage(UUID.generate(), "wm.server:connect", null, null, 3, null));
        CommException e = replyMsg.getError();
        if (e != null) {
            throw e;
        }
        this.setEndPointInfo(replyMsg.getData());
        this.isConnected = true;
        this.pinger = new Pinger(120000L);
        this.pinger.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WmMessage transportMsg(WmMessage msg) {
        InputStream ipStream = null;
        OutputStream opStream = null;
        WmMessage result = null;
        Object savedCredentials = TrustManager.getKeyAndChain();
        HttpURLConnection uc = null;
        try {
            TrustManager.setKeyAndChain(this.sslCredentials);
            Values context = new Values();
            context.put("timeout", new Integer(0));
            context.put("keepalive", new Integer(5));
            uc = HttpURLConnection.getHttpURLConnection(this.createURL(), context);
            IDataBinCoder idataCoder = new IDataBinCoder();
            uc.setDoOutput(true);
            if (this.basicAuth != null) {
                uc.setRequestProperty("Authorization", Strings.cat("Basic ", this.basicAuth));
            }
            if (this.sessionId != null) {
                uc.setRequestProperty("Cookie", Strings.cat("ssnid=", this.sessionId));
            }
            opStream = uc.getOutputStream();
            uc.setRequestProperty("Content-Type", idataCoder.getContentType());
            uc.setRequestProperty("Accept-Language", this.locale);
            idataCoder.encode(opStream, msg.getIData());
            ipStream = uc.getInputStream();
            IData returnData = idataCoder.decode(ipStream);
            if (returnData == null) {
                throw new Exception("Transport Error: Unable to connect, incompatible remote endpoint");
            }
            result = WmMessage.createMessage(returnData);
            String newSessionId = this.getCookieId(uc.getHeaderField("Set-Cookie"));
            if (newSessionId != null && !newSessionId.equals(this.sessionId)) {
                this.sessionId = newSessionId;
            }
            this.setNeedPing(false);
            if (!this.isValid && this.linkListener != null) {
                this.linkListener.linkReconnect();
            }
            this.isValid = true;
            WmMessage.checkForError(result);
        }
        catch (Net504Exception n504e) {
            if (this.linkListener != null) {
                this.linkListener.linkError(new CommException(n504e));
            }
        }
        catch (IOException ioe) {
            this.isValid = false;
            int code = 200;
            String errMsg = "";
            CommException e = null;
            if (uc != null) {
                code = uc.getResponseCode();
                errMsg = uc.getResponseMessage();
            }
            if (code == 401 || code == 403 || code == 500) {
                e = new CommException(errMsg);
            } else {
                errMsg = ioe.getMessage();
                if (errMsg != null) {
                    if (errMsg.indexOf("Invalid Session") < 0 && errMsg.indexOf("Authorization Required") < 0 && this.linkListener != null && this.isConnected) {
                        this.linkListener.linkDown();
                    }
                } else if (this.linkListener != null && this.isConnected) {
                    this.linkListener.linkDown();
                }
                e = new CommException(ioe);
            }
            result = WmMessage.createCorelatedMessage(msg, null);
            result.setError(e);
        }
        catch (Throwable ioe) {
            this.isValid = false;
            CommException e = new CommException(ioe);
            result = WmMessage.createCorelatedMessage(msg, null);
            result.setError(e);
        }
        finally {
            TrustManager.setKeyAndChain(savedCredentials);
            if (ipStream != null) {
                try {
                    ipStream.close();
                }
                catch (IOException ioe) {}
            }
            if (opStream != null) {
                try {
                    opStream.close();
                }
                catch (IOException ioe) {}
            }
            if (uc instanceof HttpURLConnection) {
                HttpURLConnection huc = uc;
                huc.disconnect();
            }
            return result;
        }
    }

    public void disconnect() {
        try {
            String uuid = UUID.generate();
            WmMessage requestMsg = InvokeMessage.createMessage(uuid, "wm.server:disconnect", null, null, 3, null);
            WmMessage replyMsg = this.transportMsg(requestMsg);
            this.isConnected = false;
            if (this.pinger != null) {
                this.pinger.interrupt();
            }
            this.setNeedPing(false);
            this.pinger = null;
            this.basicAuth = null;
            this.host = null;
            this.sessionId = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void setNeedPing(boolean ping) {
        this.needPing = ping;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void pingServer() {
        if (!this.needPing) {
            return;
        }
        try {
            String uuid = UUID.generate();
            WmMessage requestMsg = InvokeMessage.createMessage(uuid, "wm.server:ping", null, null, 3, null);
            WmMessage replyMsg = this.transportMsg(requestMsg);
            if (replyMsg.getError() == null) {
                // empty if block
            }
        }
        catch (Exception e) {
            JournalLogger.logInfo(3, 36);
        }
        this.setNeedPing(true);
    }

    private String getCookieId(String cookie) {
        if (cookie == null) {
            return null;
        }
        int len = cookie.indexOf("ssnid=");
        if (len >= 0) {
            int len2 = cookie.indexOf(";", len + 1);
            return cookie.substring(len + 6, len2);
        }
        return null;
    }

    class Pinger
    extends Thread {
        long timeout;

        public Pinger() {
            this(120000L);
        }

        public Pinger(long timeout) {
            super("SessionHTTPLink:Pinger");
            this.timeout = timeout;
        }

        public void run() {
            try {
                while (true) {
                    Pinger.sleep(this.timeout);
                    SessionHTTPLink.this.pingServer();
                    SessionHTTPLink.this.setNeedPing(true);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

