/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b.http;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.driver.comm.b2b.WmMessage;
import com.wm.driver.comm.b2b.WmSecurityContext;
import com.wm.driver.comm.b2b.http.RequestStore;
import com.wm.io.comm.CommException;
import com.wm.io.comm.ILink;
import com.wm.io.comm.ILinkListener;
import com.wm.io.comm.ILinkParameters;
import com.wm.io.comm.IMessage;
import com.wm.net.Disconnectable;
import com.wm.net.HttpURLConnection;
import com.wm.security.Config;
import com.wm.security.TrustManager;
import com.wm.util.Base64;
import com.wm.util.Strings;
import com.wm.util.coder.IDataBinCoder;
import com.wm.util.comm.LinkParameters;
import com.wm.util.text.UUID;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class HTTPLink
implements ILink {
    protected static final String INIT_CMD = "wm.server:connect";
    protected static final String SERVER_VERSION_KEY = "$version";
    protected static final String RPC_VERSION_KEY = "$rpc2ver";
    static final boolean log = false;
    protected java.net.HttpURLConnection link;
    protected String host;
    protected String basicAuth;
    protected Object sslCredentials;
    protected int port;
    protected LinkParameters linkParms;
    protected ILinkListener linkListener;
    private String id;
    protected boolean isValid;
    protected RequestStore outGoingRequestStore = new RequestStore(11);
    protected String locale;
    protected boolean isSecure = false;
    protected boolean isConnected;

    public HTTPLink(LinkParameters linkParms) throws CommException {
        try {
            this.linkParms = linkParms;
            this.id = "http:" + UUID.generate();
            WmSecurityContext ctx = (WmSecurityContext)linkParms.getSecurityContext();
            if (ctx != null) {
                String user = ctx.getUser();
                String pass = ctx.getPassword();
                this.basicAuth = user != null && user.length() > 0 ? (pass != null ? Base64.encode(Strings.cat(user, ":", pass), false) : Base64.encode(Strings.cat(user, ":"), false)) : null;
                this.sslCredentials = ctx.getSSLCredentials();
                if (this.sslCredentials != null) {
                    TrustManager.setKeyAndChain(this.sslCredentials);
                }
            }
            Properties linkArgs = linkParms.getArgs();
            this.isSecure = new Boolean((String)linkArgs.get("secure"));
            this.locale = (String)linkArgs.get("locale");
            if (this.locale == null) {
                this.locale = Locale.getDefault().toString();
            }
            this.parseLink(linkParms.getURL());
            this.isConnected = true;
        }
        catch (Exception e) {
            this.isValid = false;
            if (this.linkListener != null) {
                this.linkListener.linkDown();
            }
            throw new CommException(e);
        }
    }

    private IData createHeader() {
        IData hdr = IDataFactory.create();
        IDataCursor cr = hdr.getCursor();
        cr.insertAfter("MessageType", "SocketMessage");
        cr.destroy();
        return hdr;
    }

    protected void send(WmMessage msg) throws CommException {
        new Thread((Runnable)new HTTPSendReceive(this, msg), "HTTPSendReceive").start();
    }

    public void send(String uuid, String cmd, Properties prop, IData data) throws CommException {
        WmMessage requestMsg = WmMessage.createMessage(uuid, cmd, null, data, 3, prop);
        this.send(requestMsg);
    }

    public ILinkParameters getLinkInfo() {
        return this.linkParms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WmMessage transportMsg(WmMessage msg) {
        InputStream ipStream = null;
        OutputStream opStream = null;
        WmMessage result = null;
        Object savedCredentials = TrustManager.getKeyAndChain();
        try {
            TrustManager.setKeyAndChain(this.sslCredentials);
            HttpURLConnection uc = HttpURLConnection.getHttpURLConnection(this.createURL());
            IDataBinCoder idataCoder = new IDataBinCoder();
            ((URLConnection)uc).setDoOutput(true);
            if (this.basicAuth != null) {
                ((URLConnection)uc).setRequestProperty("Authorization", Strings.cat("Basic ", this.basicAuth));
            }
            opStream = ((URLConnection)uc).getOutputStream();
            ((URLConnection)uc).setRequestProperty("Content-Type", idataCoder.getContentType());
            ((URLConnection)uc).setRequestProperty("Connection", "keep-alive");
            ((URLConnection)uc).setRequestProperty("Accept-Language", this.locale);
            idataCoder.encode(opStream, msg.getIData());
            ipStream = ((URLConnection)uc).getInputStream();
            IData returnData = idataCoder.decode(ipStream);
            if (returnData == null) {
                throw new Exception("Transport Error: Unable to connect, incompatible remote endpoint");
            }
            result = WmMessage.createMessage(returnData);
            if (!this.isValid && this.linkListener != null) {
                this.linkListener.linkReconnect();
            }
            this.isValid = true;
            WmMessage.checkForError(result);
        }
        catch (IOException ioe) {
            this.isValid = false;
            String errMsg = ioe.getMessage();
            if (errMsg != null) {
                if (errMsg.indexOf("Invalid Session") < 0 && errMsg.indexOf("Authorization Required") < 0 && this.linkListener != null && this.isConnected) {
                    this.linkListener.linkDown();
                }
            } else if (this.linkListener != null && this.isConnected) {
                this.linkListener.linkDown();
            }
            CommException e = new CommException(ioe);
            result = WmMessage.createCorelatedMessage(msg, null);
            result.setError(e);
        }
        catch (Throwable t) {
            this.isValid = false;
            CommException e = new CommException(t);
            result = WmMessage.createCorelatedMessage(msg, null);
            result.setError(e);
        }
        finally {
            TrustManager.setKeyAndChain(savedCredentials);
            if (ipStream != null) {
                try {
                    if (ipStream instanceof Disconnectable) {
                        Disconnectable dc = (Disconnectable)((Object)ipStream);
                        dc.disconnect();
                    } else {
                        ipStream.close();
                    }
                }
                catch (IOException ioe) {}
            }
            if (opStream != null) {
                try {
                    opStream.close();
                }
                catch (IOException ioe) {}
            }
            return result;
        }
    }

    public IMessage receive(boolean poll) throws CommException {
        if (poll && !this.outGoingRequestStore.isMessageAvailable()) {
            return null;
        }
        IMessage msg = (IMessage)this.outGoingRequestStore.getMessage(0L);
        return msg;
    }

    public void disconnect() {
        try {
            this.isConnected = false;
            if (this.linkListener != null) {
                this.linkListener.linkDown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLinkListener(ILinkListener cl) {
        this.linkListener = cl;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getId() {
        return this.id;
    }

    protected void parseLink(String url) throws MalformedURLException {
        StringTokenizer st = new StringTokenizer(url, ":");
        int count = st.countTokens() - 2;
        if (count < 0) {
            throw new MalformedURLException("not enough fields");
        }
        this.host = st.nextToken();
        try {
            this.port = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException nfe) {
            throw new MalformedURLException("incorrect port number");
        }
    }

    protected URL createURL() throws MalformedURLException {
        URL url = new URL(Strings.cat(this.isSecure ? "https://" : "http://", this.host, ":", String.valueOf(this.port), "/wm-message"));
        return url;
    }

    protected void setEndPointInfo(IData endPointData) {
        if (endPointData == null) {
            return;
        }
        Properties linkProps = this.linkParms.getArgs();
        if (linkProps != null) {
            IDataCursor cr = endPointData.getCursor();
            if (cr.first(SERVER_VERSION_KEY)) {
                linkProps.put(SERVER_VERSION_KEY, cr.getValue());
            }
            if (cr.first(RPC_VERSION_KEY)) {
                linkProps.put(RPC_VERSION_KEY, cr.getValue());
            }
        }
    }

    static {
        Config.setupProviders();
        if (com.wm.util.Config.getProperty("false", "watt.net.useURLFactory").equalsIgnoreCase("true")) {
            try {
                Class<?> c = Class.forName("com.wm.net.URLStreamHandlerFactory");
                if (c != null) {
                    URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)c.newInstance());
                }
            }
            catch (Throwable throwable) {}
        } else {
            com.wm.util.Config.setProtocolPath();
        }
    }

    class HTTPSendReceive
    implements Runnable {
        HTTPLink link;
        WmMessage msg;

        public HTTPSendReceive(HTTPLink link, WmMessage msg) {
            this.link = link;
            this.msg = msg;
        }

        public void run() {
            WmMessage replyMsg = this.link.transportMsg(this.msg);
            HTTPLink.this.outGoingRequestStore.putMessage(replyMsg);
        }
    }
}

