/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b.http;

import com.wm.driver.comm.b2b.WmConnectionParms;
import com.wm.g11n.util.iContext;
import com.wm.g11n.util.rfc3066bis;
import com.wm.util.comm.LinkParameters;
import java.util.Locale;
import java.util.Properties;

public class HTTPConnectionParms
extends WmConnectionParms {
    public static final boolean log = true;
    String secondaryURL;
    int defPort = 5555;
    String locale = iContext.getDefault().toString();

    public HTTPConnectionParms(String url) {
        this(url, null);
    }

    public HTTPConnectionParms(String url, Properties linkProperties) {
        super(url, linkProperties);
    }

    public void setProxy(String host, String user, String pass) {
        if (host == null || host.length() == 0) {
            System.getProperties().put("watt.net.proxyHost", "");
            System.getProperties().put("watt.net.proxyPort", "");
            System.getProperties().put("watt.net.proxyUser", "");
            System.getProperties().put("watt.net.proxyPass", "");
        } else {
            System.getProperties().put("watt.net.proxyHost", this.getHost(host));
            System.getProperties().put("watt.net.proxyPort", this.getPort(host, "80"));
            if (user != null) {
                System.getProperties().put("watt.net.proxyUser", user);
            }
            if (pass != null) {
                System.getProperties().put("watt.net.proxyPass", pass);
            }
        }
    }

    public void setSecureProxy(String host, String user, String pass) {
        if (host == null || host.length() == 0) {
            System.getProperties().remove("watt.net.secureProxyHost");
            System.getProperties().remove("watt.net.secureProxyPort");
            System.getProperties().remove("watt.net.secureProxyUser");
            System.getProperties().remove("watt.net.secureProxyPass");
        } else {
            System.getProperties().put("watt.net.secureProxyHost", this.getHost(host));
            System.getProperties().put("watt.net.secureProxyPort", this.getPort(host, "80"));
            if (user != null) {
                System.getProperties().put("watt.net.secureProxyUser", user);
            }
            if (pass != null) {
                System.getProperties().put("watt.net.secureProxyPass", pass);
            }
        }
    }

    public LinkParameters getLinkParameters() {
        if (this.linkParms == null) {
            if (this.mainArgs == null) {
                this.mainArgs = new Properties();
            }
            this.mainArgs.put("QosType", String.valueOf(this.qosType));
            if (this.secondaryURL != null) {
                this.mainArgs.put("SecondaryServer", this.secondaryURL);
            }
            this.mainArgs.put("secure", this.isSecure ? "true" : "false");
            this.mainArgs.put("locale", this.locale);
            this.linkParms = new LinkParameters(this.url, this.secCtx, this.mainArgs);
        }
        return this.linkParms;
    }

    public void setEndPoint(String url) {
        this.url = url;
    }

    public void setSecondaryEndPoint(String url) {
        this.secondaryURL = url;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.locale = "";
        }
        this.locale = new iContext(locale).toString();
    }

    public void setLocale(String locale) {
        if (locale == null) {
            return;
        }
        if (rfc3066bis.isValid((String)locale)) {
            this.locale = locale;
        }
    }

    public String getURL() {
        return this.url;
    }

    protected String getHost(String hostport) {
        if (hostport == null || hostport.length() == 0) {
            return null;
        }
        int pos = hostport.indexOf(58);
        if (pos < 0) {
            return hostport;
        }
        return hostport.substring(0, pos);
    }

    protected String getPort(String hostport, String defPort) {
        if (hostport == null) {
            return "";
        }
        int pos = hostport.indexOf(58);
        if (pos < 0 || pos == hostport.length() - 1) {
            return defPort;
        }
        try {
            return hostport.substring(pos + 1);
        }
        catch (NumberFormatException e) {
            return defPort;
        }
    }
}

