/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b.http;

import com.wm.app.b2b.client.ServiceException;
import com.wm.data.IData;
import com.wm.driver.comm.b2b.WmCommException;
import com.wm.driver.comm.b2b.WmConnection;
import com.wm.driver.comm.b2b.WmConnectionParms;
import com.wm.io.comm.CommException;
import com.wm.io.comm.ILinkListener;
import com.wm.io.comm.IMessage;
import com.wm.io.comm.IMessageHandler;
import com.wm.util.Values;
import com.wm.util.comm.Connection;
import com.wm.util.text.UUID;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

public class HTTPConnection
implements WmConnection {
    static final boolean log = false;
    protected Connection conn;
    protected WmConnectionParms connParms;
    private String id;

    public HTTPConnection(Connection conn, WmConnectionParms cParms) {
        Properties args;
        this.conn = conn;
        this.connParms = cParms;
        this.id = "http:" + UUID.generate();
        Properties properties = args = this.connParms != null ? this.connParms.getArgs() : null;
        if (args != null) {
            args.put("id", this.id);
        }
    }

    public String send(String cmd, Properties prop, IData data) throws ServiceException {
        ServiceException se = null;
        try {
            return this.conn.send(cmd, prop, data);
        }
        catch (CommException ce) {
            Throwable t = ce.getWrappedException();
            if (t != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                se = new ServiceException(t.getMessage(), t.getMessage(), t.getClass().getName(), sw.toString(), null);
            } else {
                se = new ServiceException(ce);
            }
            throw se;
        }
        catch (Exception e) {
            se = new ServiceException(e);
            throw se;
        }
    }

    public void sendOnly(String cmd, Properties prop, IData data) throws ServiceException {
        ServiceException se = null;
        try {
            String uuid = UUID.generate();
            this.conn.send(uuid, cmd, prop, data);
        }
        catch (CommException ce) {
            Throwable t = ce.getWrappedException();
            if (t != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                se = new ServiceException(t.getMessage(), t.getMessage(), t.getClass().getName(), sw.toString(), null);
            } else {
                se = new ServiceException(ce);
            }
        }
        catch (Exception e) {
            se = new ServiceException(e);
            throw se;
        }
    }

    public IData receive(String uuid, long wait) throws ServiceException {
        ServiceException se = null;
        try {
            IMessage msg = this.conn.waitReply(uuid, wait);
            IData retData = null;
            if (msg != null) {
                retData = msg.getData();
            }
            return retData;
        }
        catch (WmCommException wmce) {
            IData encodedError = wmce.getEncodedError();
            se = encodedError != null ? new ServiceException(Values.use(encodedError)) : new ServiceException(wmce);
            throw se;
        }
        catch (CommException ce) {
            Throwable t = ce.getWrappedException();
            if (t != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                se = new ServiceException(t.getMessage(), t.getMessage(), t.getClass().getName(), sw.toString(), null);
            } else {
                se = new ServiceException(ce);
            }
            throw se;
        }
        catch (Exception e) {
            se = new ServiceException(e);
            throw se;
        }
    }

    public IData sendReceive(String cmd, Properties prop, IData data) throws ServiceException {
        int waitTime = 0;
        if (prop != null) {
            try {
                String waitTimeString = prop.getProperty("WAIT_TIME");
                waitTime = Integer.parseInt(waitTimeString);
            }
            catch (Throwable e) {
                waitTime = 0;
            }
        }
        return this.receive(this.send(cmd, prop, data), waitTime);
    }

    public void registerMessageHandler(String cmd, IMessageHandler handler) {
        this.conn.registerMessageHandler(cmd, handler);
    }

    public void unRegisterMessageHandler(String cmd) {
        this.conn.registerMessageHandler(cmd, null);
    }

    public void setDefaultHandler(IMessageHandler handler) {
        this.conn.setDefaultHandler(handler);
    }

    public void setLinkListener(ILinkListener cl) {
        this.conn.setLinkListener(cl);
    }

    public void setLinkReady() {
        this.conn.setLinkReady();
    }

    public void disconnect() {
        this.conn.disconnect();
    }

    public WmConnectionParms getConnectionParms() {
        return this.connParms;
    }

    public String toString() {
        return "HTTPConnection:" + this.conn;
    }

    public void handleLinkError(CommException err) {
    }
}

