/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataHashCursor;
import com.wm.driver.comm.b2b.DocumentMessage;
import com.wm.driver.comm.b2b.InvokeMessage;
import com.wm.driver.comm.b2b.WmCommException;
import com.wm.io.comm.CommException;
import com.wm.io.comm.IMessage;
import com.wm.util.coder.IDataCodable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.Vector;

public abstract class WmMessage
implements IDataCodable,
IMessage {
    public static final long DEFAULT_TTL = 180000L;
    public static final boolean log = false;
    public static final int INVOKE_MESSAGE = 3;
    public static final int DOCUMENT_MESSAGE = 4;
    public static final String UUID = "UUID";
    public static final String COMMAND = "COMMAND";
    public static final String HEADER = "HEADER";
    public static final String BODY = "BODY";
    public static final String MSGTYPE = "MSGTYPE";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String TTL = "TTL";
    public static final String ERROR = "ERROR";
    public static final String MESSAGE_TYPE_KEY = "MessageType";
    public static final String CONTENT_TYPE_KEY = "Content-Type";
    public static final String SESSION_KEY = "Cookie";
    public static final String USER_AGENT_KEY = "User-Agent";
    public static final String BASIC_AUTH_KEY = "Authorization";
    public static final String SECURE_AUTH_KEY = "SSL-Authorization";
    public static final String LANGUAGE_KEY = "Accept-Language";
    public static final String SESSION_RESPONSE_KEY = "Set-Cookie";
    public static final String REQUIRE_CLIENTAUTH_KEY = "$clientAuth";
    public static final String PROTOCOL_PROPS_KEY = "ProtocolProps";
    public static final String REQUEST_URL = "requestUrl";
    public static final String REQUEST_HDRS = "requestHdrs";
    public static final String REQUEST_QRY = "query";
    public static final String PROTOCOL_RES_PROPS_KEY = "ProtocolResProps";
    protected String uuid;
    protected String cmd;
    protected IData hdr;
    protected IData body;
    protected Properties props;
    protected long ttl;
    protected int msgType;
    protected CommException err;

    public WmMessage() {
        this.msgType = 3;
        this.ttl = 180000L;
    }

    protected WmMessage(String uuid, String cmd, IData hdr, IData data, long ttl, int msgType, Properties props) {
        this.uuid = uuid;
        this.cmd = cmd;
        this.hdr = hdr;
        this.body = data;
        this.ttl = ttl;
        this.msgType = msgType;
        this.props = props;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getCommand() {
        return this.cmd;
    }

    public Properties getProperties() {
        return this.props;
    }

    public IData getData() {
        return this.body;
    }

    public CommException getError() {
        return this.err;
    }

    public IData getHeader() {
        return this.hdr;
    }

    public long getTTL() {
        return this.ttl;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setData(IData d) {
        this.body = d;
    }

    public void setHeader(IData h) {
        this.hdr = h;
    }

    public void setError(CommException e) {
        this.err = e;
    }

    public String getContentType() {
        if (this.hdr != null) {
            IDataCursor cr = this.hdr.getCursor();
            String ctype = null;
            if (cr.first(CONTENT_TYPE_KEY)) {
                ctype = (String)cr.getValue();
            }
            cr.destroy();
            return ctype;
        }
        return null;
    }

    public void setContentType(String contentType) {
        if (this.hdr != null) {
            IDataCursor cr = this.hdr.getCursor();
            if (contentType == null) {
                if (cr.first(CONTENT_TYPE_KEY)) {
                    cr.delete();
                }
            } else if (cr.first(CONTENT_TYPE_KEY)) {
                cr.setValue(contentType);
            } else {
                cr.insertAfter(CONTENT_TYPE_KEY, contentType);
            }
            cr.destroy();
        }
    }

    public String getLocale() {
        if (this.hdr != null) {
            IDataHashCursor cr = this.hdr.getHashCursor();
            String locale = null;
            if (cr.first(LANGUAGE_KEY)) {
                locale = (String)cr.getValue();
            }
            cr.destroy();
            return locale;
        }
        return null;
    }

    public IData getResponseHeaders() {
        if (this.hdr != null) {
            IDataHashCursor cr = this.hdr.getHashCursor();
            IData responseHdrs = null;
            if (cr.first(PROTOCOL_RES_PROPS_KEY)) {
                responseHdrs = (IData)cr.getValue();
            }
            cr.destroy();
            return responseHdrs;
        }
        return null;
    }

    public void setResponseHeaders(IData responseHdrs) {
        if (this.hdr != null) {
            IDataHashCursor cr = this.hdr.getHashCursor();
            if (responseHdrs == null) {
                if (cr.first(PROTOCOL_RES_PROPS_KEY)) {
                    cr.delete();
                }
            } else if (cr.first(PROTOCOL_RES_PROPS_KEY)) {
                cr.setValue(responseHdrs);
            } else {
                cr.insertAfter(PROTOCOL_RES_PROPS_KEY, responseHdrs);
            }
            cr.destroy();
        }
    }

    public String getUserAgent() {
        if (this.hdr != null) {
            IDataCursor cr = this.hdr.getCursor();
            String ctype = null;
            if (cr.first(USER_AGENT_KEY)) {
                ctype = (String)cr.getValue();
            }
            cr.destroy();
            return ctype;
        }
        return null;
    }

    public String getSessionID() {
        if (this.hdr != null) {
            IDataCursor cr = this.hdr.getCursor();
            cr.first(SESSION_KEY);
            String ctype = (String)cr.getValue();
            cr.destroy();
            return ctype;
        }
        return null;
    }

    public String getSessionResponseID() {
        if (this.hdr != null) {
            IDataCursor cr = this.hdr.getCursor();
            cr.first(SESSION_RESPONSE_KEY);
            String ctype = (String)cr.getValue();
            cr.destroy();
            return ctype;
        }
        return null;
    }

    public void setSessionID(String ssnId) {
        if (this.hdr != null) {
            IDataCursor cr = this.hdr.getCursor();
            if (ssnId == null) {
                if (cr.first(SESSION_RESPONSE_KEY)) {
                    cr.delete();
                }
            } else if (cr.first(SESSION_RESPONSE_KEY)) {
                cr.setValue(ssnId);
            } else {
                cr.insertAfter(SESSION_RESPONSE_KEY, ssnId);
            }
            cr.destroy();
        }
    }

    public static Vector createSerializableCertificates(X509Certificate[] chain) {
        Vector<byte[]> v = new Vector<byte[]>(chain.length);
        try {
            for (int i = 0; i < chain.length; ++i) {
                v.addElement(chain[i].getEncoded());
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return v;
    }

    public static X509Certificate[] deSerializeCertificates(Vector v) throws CertificateException {
        int size = v.size();
        X509Certificate[] chain = new X509Certificate[size];
        for (int i = 0; i < size; ++i) {
            byte[] b = (byte[])v.elementAt(i);
            iaik.x509.X509Certificate cert = new iaik.x509.X509Certificate(b);
            chain[i] = cert;
        }
        return chain;
    }

    public void setIData(IData data) {
        IDataCursor idhc = data.getCursor();
        this.uuid = idhc.first(UUID) ? (String)idhc.getValue() : null;
        this.cmd = idhc.first(COMMAND) ? (String)idhc.getValue() : null;
        this.hdr = idhc.first(HEADER) ? (IData)idhc.getValue() : null;
        this.body = idhc.first(BODY) ? (IData)idhc.getValue() : null;
        this.msgType = idhc.first(MSGTYPE) ? (Integer)idhc.getValue() : 3;
        this.ttl = idhc.first(TTL) ? (Long)idhc.getValue() : 180000L;
        this.err = idhc.first(ERROR) ? (CommException)idhc.getValue() : null;
        idhc.destroy();
    }

    public IData getIData() {
        IData idata = IDataFactory.create();
        IDataCursor idc = idata.getCursor();
        idc.insertAfter(UUID, this.uuid);
        idc.insertAfter(COMMAND, this.cmd);
        idc.insertAfter(HEADER, this.hdr);
        idc.insertAfter(BODY, this.body);
        idc.insertAfter(MSGTYPE, new Integer(this.msgType));
        idc.insertAfter(TTL, new Long(this.ttl));
        if (this.err != null) {
            idc.insertAfter(ERROR, this.err);
        }
        idc.destroy();
        return idata;
    }

    public String toString() {
        return "(" + this.getUUID() + "," + this.getCommand() + "," + this.getHeader() + "," + this.getData() + "," + this.getMsgType() + "," + this.getTTL() + ")";
    }

    public static void checkForError(WmMessage msg) {
        IData msgBody = msg.getData();
        if (msgBody == null) {
            return;
        }
        IDataCursor dc = msgBody.getCursor();
        if (dc.first("$errorInfo")) {
            IData errorStructure = (IData)dc.getValue();
            StringBuffer errMsg = new StringBuffer();
            IDataCursor esCur = errorStructure.getCursor();
            if (esCur.first("$localizedError")) {
                errMsg.append(esCur.getValue());
            } else if (esCur.first("$error")) {
                errMsg.append(esCur.getValue());
            }
            WmCommException wce = new WmCommException(errMsg.toString(), msgBody);
            msg.setError(wce);
        }
    }

    public static WmMessage createMessage(String uuid, String cmd, IData hdr, IData data, int msgType, Properties props) {
        switch (msgType) {
            case 3: {
                return new InvokeMessage(uuid, cmd, hdr, data, 180000L, props);
            }
            case 4: {
                return new DocumentMessage(uuid, cmd, hdr, data, 180000L, props);
            }
        }
        return new InvokeMessage(uuid, cmd, hdr, data, 180000L, props);
    }

    public static WmMessage createMessage(IData container) {
        IDataCursor idhc = container.getCursor();
        WmMessage msg = null;
        int mType = 3;
        if (idhc.first(MSGTYPE)) {
            mType = (Integer)idhc.getValue();
        }
        switch (mType) {
            case 3: {
                msg = new InvokeMessage();
                msg.setIData(container);
                break;
            }
            case 4: {
                msg = new DocumentMessage();
                msg.setIData(container);
                break;
            }
            default: {
                msg = new InvokeMessage();
                msg.setIData(container);
            }
        }
        return msg;
    }

    public static WmMessage createCorelatedMessage(WmMessage msg, IData data) {
        switch (msg.getMsgType()) {
            case 3: {
                return new InvokeMessage(msg.getUUID(), msg.getCommand(), msg.getHeader(), data, 180000L, msg.getProperties());
            }
            case 4: {
                return new DocumentMessage(msg.getUUID(), msg.getCommand(), msg.getHeader(), data, 180000L, msg.getProperties());
            }
        }
        return new InvokeMessage(msg.getUUID(), msg.getCommand(), msg.getHeader(), data, 180000L, msg.getProperties());
    }
}

