/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b;

import com.wm.driver.comm.b2b.WmSecurityContext;
import com.wm.io.comm.CommException;
import com.wm.security.TrustManager;
import com.wm.util.comm.LinkParameters;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;

public abstract class WmConnectionParms {
    public static final boolean log = false;
    public static final int QOS_GD = 1;
    public static final int QOS_VOLATILE = 2;
    public static final int TRANSPORT_HTTP = 1;
    public static final int TRANSPORT_HTTPS = 2;
    public static final int TRANSPORT_SOCK = 3;
    public static final int RPC_XML = 2;
    public static final int RPC_IDAT = 3;
    protected String url;
    protected Properties mainArgs;
    protected LinkParameters linkParms;
    protected String proxyServer;
    protected String userName;
    protected String password;
    protected String proxyUser;
    protected String proxyPass;
    protected String privKey;
    protected String[] certChain;
    protected int qosType = 2;
    protected int transportType = 1;
    protected int rpcType;
    protected int rpcVer;
    protected String encoding;
    protected boolean useSession = false;
    protected boolean isSecure = false;
    protected WmSecurityContext secCtx;

    public WmConnectionParms(String url) {
        this(url, null);
    }

    public WmConnectionParms(String url, Properties connectionProperties) {
        this.url = url;
        this.mainArgs = connectionProperties;
    }

    public void setRPCType(int rpcType) {
        this.rpcType = rpcType;
    }

    public void setRPCVer(int rpcVer) {
        this.rpcVer = rpcVer;
    }

    public void setTransport(int transport) throws CommException {
        switch (transport) {
            case 1: {
                this.transportType = transport;
                break;
            }
            case 2: {
                this.transportType = transport;
                break;
            }
            case 3: {
                this.transportType = transport;
                break;
            }
            default: {
                throw new CommException("Unsupported TRANSPORT type:" + transport);
            }
        }
    }

    public int getTransportType() {
        return this.transportType;
    }

    public void setUserCredentials(String userName, String password) {
        if (this.secCtx == null) {
            this.secCtx = new WmSecurityContext(userName, password);
        } else {
            this.secCtx.setBasicCredentials(userName, password);
        }
    }

    public void setUserCredentials(String privKey, String[] certChain) throws CertificateException, IOException, InvalidKeyException {
        Object kac = TrustManager.loadKeyAndChain(privKey, certChain);
        if (kac == null) {
            throw new InvalidKeyException("Invalid key chain specified");
        }
        TrustManager.setKeyAndChain(kac);
        if (this.secCtx == null) {
            this.secCtx = new WmSecurityContext(kac);
        } else {
            this.secCtx.setSSLCredentials(kac);
        }
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }

    public boolean getUseSession() {
        return this.useSession;
    }

    public void setQOS(int qosType) throws CommException {
        switch (qosType) {
            case 1: {
                this.qosType = qosType;
                break;
            }
            case 2: {
                this.qosType = qosType;
                break;
            }
            default: {
                throw new CommException("Unsupported QOS type:" + qosType);
            }
        }
    }

    public int getQOS() {
        return this.qosType;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getEndPoint() {
        return this.url;
    }

    public Properties getArgs() {
        return this.mainArgs;
    }

    public String getArg(String arg, String def) {
        if (this.mainArgs == null) {
            return def;
        }
        Object ret = this.mainArgs.get(arg);
        if (ret != null) {
            return ret.toString();
        }
        return def;
    }

    public abstract LinkParameters getLinkParameters();

    public abstract void setEndPoint(String var1);

    public abstract void setSecondaryEndPoint(String var1);

    public String toString() {
        return this.url + ":qos=" + this.qosType + ":transport=" + this.transportType + ":session=" + this.useSession;
    }
}

