/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b;

import com.wm.app.b2b.client.ServiceException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.driver.comm.b2b.WmCommException;
import com.wm.driver.comm.b2b.WmConnection;
import com.wm.driver.comm.b2b.WmConnectionParms;
import com.wm.driver.comm.b2b.http.HTTPConnection;
import com.wm.driver.comm.b2b.http.HTTPLink;
import com.wm.driver.comm.b2b.http.HTTPLinkFactory;
import com.wm.driver.comm.b2b.http.SessionHTTPLink;
import com.wm.driver.comm.b2b.socket.SessionSocketLink;
import com.wm.driver.comm.b2b.socket.SocketConnection;
import com.wm.driver.comm.b2b.socket.SocketLink;
import com.wm.driver.comm.b2b.socket.SocketLinkFactory;
import com.wm.io.comm.CommException;
import com.wm.io.comm.ILinkFactory;
import com.wm.util.Values;
import com.wm.util.comm.Connection;

public class WmConnectionFactory {
    public static final boolean log = true;

    public static WmConnection create(WmConnectionParms connParms) throws ServiceException {
        ServiceException se = null;
        WmConnection returnConn = null;
        try {
            boolean isSecure = connParms.isSecure();
            ILinkFactory factory = null;
            switch (connParms.getTransportType()) {
                case 1: {
                    factory = HTTPLinkFactory.create();
                    if (connParms.getUseSession()) {
                        SessionHTTPLink link = new SessionHTTPLink(connParms.getLinkParameters());
                        Connection conn = new Connection(link);
                        returnConn = new HTTPConnection(conn, connParms);
                        break;
                    }
                    if (connParms.getQOS() == 2) {
                        HTTPLink link = (HTTPLink)factory.openLink(connParms.getLinkParameters());
                        Connection conn = new Connection(link);
                        returnConn = new HTTPConnection(conn, connParms);
                        break;
                    }
                    if (connParms.getQOS() != 1) break;
                    throw new CommException("GD HTTP IConnection not implemented yet");
                }
                case 3: {
                    System.out.println("D--->creating a SocketLink");
                    factory = SocketLinkFactory.create();
                    if (connParms.getUseSession()) {
                        SessionSocketLink link = (SessionSocketLink)factory.openLink(connParms.getLinkParameters());
                        Connection conn = new Connection(link);
                        returnConn = new SocketConnection(conn, connParms);
                        break;
                    }
                    if (connParms.getQOS() == 2) {
                        SocketLink link = (SocketLink)factory.openLink(connParms.getLinkParameters());
                        Connection conn = new Connection(link);
                        returnConn = new SocketConnection(conn, connParms);
                        break;
                    }
                    if (connParms.getQOS() != 1) break;
                    throw new CommException("GD HTTP IConnection not implemented yet");
                }
            }
        }
        catch (WmCommException wmce) {
            IData encodedError = wmce.getEncodedError();
            if (encodedError != null) {
                IDataCursor cr = encodedError.getCursor();
                if (cr.first("$errorInfo")) {
                    IData errorStructure = (IData)cr.getValue();
                    se = new ServiceException(Values.use(errorStructure));
                }
            } else {
                se = new ServiceException(wmce);
            }
            throw se;
        }
        catch (CommException ce) {
            Throwable t = ce.getWrappedException();
            se = t != null ? new ServiceException(t.getMessage(), t.getClass().getName(), t.toString()) : new ServiceException(ce.getLocalizedMessage());
            throw se;
        }
        catch (Exception e) {
            se = new ServiceException(e);
            throw se;
        }
        return returnConn;
    }
}

