/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b;

import com.wm.app.b2b.client.ServiceException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.driver.comm.b2b.BasicEventHandler;
import com.wm.driver.comm.b2b.BasicLinkListener;
import com.wm.driver.comm.b2b.WmCommException;
import com.wm.driver.comm.b2b.WmConnection;
import com.wm.driver.comm.b2b.WmConnectionFactory;
import com.wm.driver.comm.b2b.WmConnectionParms;
import com.wm.driver.comm.b2b.http.HTTPConnectionParms;
import com.wm.driver.comm.b2b.socket.SocketConnectionParms;
import com.wm.io.comm.CommException;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public class TestClient
extends Thread {
    String url;
    WmConnection wmConn;
    int count;
    Stack req;
    IData sendData;
    String cmd;
    String name;
    long time = 0L;
    static int rate;
    static int runs;
    static Object lock;

    TestClient(String url, WmConnectionParms connParam, int count, String name, String svcName) throws Exception {
        super(name);
        this.url = url;
        this.count = count;
        this.cmd = svcName;
        this.name = name;
        this.wmConn = WmConnectionFactory.create(connParam);
        this.wmConn.setLinkReady();
    }

    TestClient(WmConnection wmConn, int count, String name, String svcName) throws Exception {
        super(name);
        this.count = count;
        this.cmd = svcName;
        this.name = name;
        this.wmConn = wmConn;
    }

    void sendAndDefReceive() throws Exception {
        Vector<String> sentID = new Vector<String>(this.count);
        for (int i = 0; i < this.count; ++i) {
            try {
                this.sendData = IDataFactory.create();
                IDataCursor cr = this.sendData.getCursor();
                cr.insertAfter("ThreadName", this.name);
                cr.insertAfter("sequenceNo", String.valueOf(i));
                cr.insertAfter("num1", "1");
                cr.insertAfter("num2", "2");
                String messageSendID = this.wmConn.send(this.cmd, null, this.sendData);
                System.out.println("---count=" + i + ": sendID=" + messageSendID + ":data=" + this.sendData);
                sentID.addElement(messageSendID);
                continue;
            }
            catch (Exception e) {
                System.out.println("---caught an exception in TestClient.test1 while doing sendRequest " + e);
            }
        }
        int totalRecv = 0;
        for (int i = 0; i < this.count; ++i) {
            try {
                IData data = this.wmConn.receive((String)sentID.elementAt(i), 0L);
                System.out.println(Thread.currentThread().getName() + "--received this reply=" + data + " Total received=" + ++totalRecv);
                continue;
            }
            catch (Exception e) {
                System.out.println("$$$error in TestClient.test1() thread:" + Thread.currentThread().getName() + " err=" + e);
            }
        }
    }

    void sendReceive() throws Exception {
        int totalRecv = 0;
        for (int i = 0; i < this.count; ++i) {
            try {
                this.sendData = IDataFactory.create();
                IDataCursor cr = this.sendData.getCursor();
                cr.insertAfter("ThreadName", this.name);
                System.out.println("---count=" + i + ": send Request :data=" + this.sendData);
                cr.insertAfter("sequenceNo", String.valueOf(i));
                cr.insertAfter("num1", "1");
                cr.insertAfter("num2", "2");
                IData replyData = this.wmConn.sendReceive(this.cmd, null, this.sendData);
                System.out.println(Thread.currentThread().getName() + "--reply=" + replyData + " Total Received=" + ++totalRecv);
                continue;
            }
            catch (ServiceException e) {
                System.out.println("---caught an ServiceException in TestClient while doing sendReceive " + e);
                continue;
            }
            catch (Exception e) {
                System.out.println("---caught an exception in TestClient while doing sendReceive " + e);
            }
        }
    }

    void asynchCallBack() throws Exception {
        this.wmConn.registerMessageHandler(this.cmd, new BasicEventHandler());
        this.sendData = IDataFactory.create();
        IDataCursor cr = this.sendData.getCursor();
        cr.insertAfter("ThreadName", this.name);
        this.wmConn.sendOnly(this.cmd, null, this.sendData);
    }

    void registerForEvent() throws Exception {
        this.wmConn.registerMessageHandler("wm.server.event:registerForEvent", new BasicEventHandler());
        try {
            this.sendData = IDataFactory.create();
            IDataCursor cr = this.sendData.getCursor();
            cr.insertAfter("ThreadName", this.name);
            String sendID = this.wmConn.send(this.cmd, null, this.sendData);
            System.out.println("O--->event registration request being sent by:" + Thread.currentThread().getName() + "--sendID=" + sendID);
        }
        catch (Exception e) {
            System.out.println("---caught an exception in TestClient.test1 while doing registerForEvent " + e);
        }
    }

    void listenForLinkDown() throws Exception {
        this.wmConn.setLinkListener(new BasicLinkListener());
        try {
            this.sendData = IDataFactory.create();
            IDataCursor cr = this.sendData.getCursor();
            cr.insertAfter("ThreadName", this.name);
            IData receive = this.wmConn.sendReceive(this.cmd, null, this.sendData);
            System.out.println("O--->Test:listenForLinkDown :" + Thread.currentThread().getName() + "return data" + receive);
        }
        catch (Exception e) {
            System.out.println("---caught an exception in TestClient while doing listenForLinkDown " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            long runtime = System.currentTimeMillis();
            this.listenForLinkDown();
            runtime = System.currentTimeMillis() - runtime;
            System.out.println("--- " + (long)(this.count * 1000) / runtime + " req/s ---");
            Object object = lock;
            synchronized (object) {
                rate = (int)((long)rate + (long)(this.count * 1000) / runtime);
                ++runs;
                lock.notify();
            }
        }
        catch (Exception e) {
            System.out.println("!!!caught an exception in TestClient.run " + e);
            e.printStackTrace();
        }
    }

    void mark(String msg) {
        long now = System.currentTimeMillis();
        if (this.time > 0L) {
            System.out.println("--- " + msg + " " + (now - this.time) + " ms ---");
        }
        this.time = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String clients = "1";
        String svcName = "wm.server:ping";
        String count = "1";
        String transport = "http";
        String session = "no";
        String qos = "volatile";
        String secure = "no";
        String testmode = "per_thread";
        if (args.length < 1) {
            System.out.println("usage: TestClient <host:port> -clients <no of clients> -count <no of iterations> -service <service_to_invoke>\t-transport <type of transport i.e http sock etc> -secure < yes|no> -session <yes|no> -qos <gd|volatile> -testmode <common|per_thread>");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-clients")) {
                clients = args[++i];
                continue;
            }
            if (args[i].equals("-service")) {
                svcName = args[++i];
                continue;
            }
            if (args[i].equals("-count")) {
                count = args[++i];
                continue;
            }
            if (args[i].equals("-transport")) {
                transport = args[++i];
                continue;
            }
            if (args[i].equals("-session")) {
                session = args[++i];
                continue;
            }
            if (args[i].equals("-secure")) {
                secure = args[++i];
                continue;
            }
            if (args[i].equals("-qos")) {
                qos = args[++i];
                continue;
            }
            if (!args[i].equals("-testmode")) continue;
            testmode = args[++i];
        }
        int threads = Integer.parseInt(clients);
        int iterations = Integer.parseInt(count);
        System.out.println("Test : Client=" + clients + " No of Iterations=" + count + " Service=" + svcName + " transport=" + transport + " session=" + session + " secure=" + secure + " QOS=" + qos + " testmode=" + testmode);
        rate = 0;
        runs = 0;
        lock = new Object();
        try {
            Properties arg = new Properties();
            WmConnectionParms connParam = null;
            if ("http".equals(transport)) {
                connParam = new HTTPConnectionParms(args[0], arg);
            } else if ("sock".equals(transport)) {
                connParam = new SocketConnectionParms(args[0], arg);
            }
            if ("yes".equals(session)) {
                connParam.setUseSession(true);
            } else {
                connParam.setUseSession(false);
            }
            if ("yes".equals(secure)) {
                connParam.setSecure(true);
                String[] keyChains = new String[]{"d:/niledevel/main/server/product/config/clientcert.der", "d:/niledevel/main/server/product/config/certdir/clientcacert.der"};
                connParam.setUserCredentials("d:/niledevel/main/server/product/config/clientprivkey.der", keyChains);
            } else {
                connParam.setSecure(false);
            }
            connParam.setUserCredentials("Administrator", "manage");
            if ("gd".equals(qos)) {
                connParam.setQOS(1);
            } else {
                connParam.setQOS(2);
            }
            boolean common = testmode.equals("common");
            if (!common) {
                for (int i = 0; i < threads; ++i) {
                    new TestClient(args[0], connParam, iterations, "TestClient:Thread-" + i, svcName).start();
                }
            } else {
                WmConnection wmConn = WmConnectionFactory.create(connParam);
                wmConn.setLinkReady();
                for (int i = 0; i < threads; ++i) {
                    new TestClient(wmConn, iterations, "TestClient:Thread:" + i, svcName).start();
                }
            }
            Object object = lock;
            synchronized (object) {
                try {
                    while (runs < threads) {
                        lock.wait();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            System.out.println("--- TOTAL " + rate + " req/s ---");
        }
        catch (WmCommException e) {
            System.out.println("---caught a WmCommException in TestClient.main " + e);
            System.out.println(e.getEncodedError());
            e.printStackTrace();
        }
        catch (CommException e) {
            System.out.println("---caught a CommException in TestClient.main " + e);
        }
        catch (Exception e) {
            System.out.println("got an exception in TestClient.main " + e);
            e.printStackTrace();
        }
    }
}

