/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.driver.comm.b2b.WmMessage;
import java.util.Properties;

public class DocumentMessage
extends WmMessage {
    public static final String DOCBODY_KEY = "$wmdocbody";
    public static final String DOCOOB_KEY = "$wmdocoob";
    protected int msgType = 4;

    public DocumentMessage() {
    }

    protected DocumentMessage(String uuid, String cmd, IData hdr, IData data, long ttl, Properties props) {
        super(uuid, cmd, hdr, data, ttl, 4, props);
    }

    public int getMsgType() {
        return this.msgType;
    }

    public static IData createIDataFromBytes(byte[] rawInput) {
        IData encodedIdata = IDataFactory.create();
        IDataCursor cr = encodedIdata.getCursor();
        cr.insertAfter(DOCBODY_KEY, rawInput);
        cr.destroy();
        return encodedIdata;
    }

    public static byte[] createBytesFromIData(IData input) {
        if (input != null) {
            IDataCursor cr = input.getCursor();
            cr.first(DOCBODY_KEY);
            byte[] docbody = (byte[])cr.getValue();
            cr.destroy();
            return docbody;
        }
        return null;
    }

    public byte[] getDocBody() {
        if (this.body != null) {
            IDataCursor cr = this.body.getCursor();
            cr.first(DOCBODY_KEY);
            byte[] docbody = (byte[])cr.getValue();
            cr.destroy();
            return docbody;
        }
        return null;
    }

    public void setDocBody(byte[] outBytes) {
        IDataCursor cr;
        if (this.body == null) {
            this.body = IDataFactory.create();
        }
        if ((cr = this.body.getCursor()).first(DOCBODY_KEY)) {
            cr.setValue(outBytes);
        } else {
            cr.insertAfter(DOCBODY_KEY, outBytes);
        }
        cr.destroy();
    }

    public static void addOutOfBand(IData payload, IData oob) {
        if (oob == null) {
            return;
        }
        IDataCursor idc = payload.getCursor();
        idc.insertAfter(DOCOOB_KEY, oob);
        idc.destroy();
    }

    public IData getOutOfBand() {
        if (this.body != null) {
            IData docoob = null;
            IDataCursor cr = this.body.getCursor();
            if (cr.first(DOCOOB_KEY)) {
                docoob = (IData)cr.getValue();
            }
            cr.destroy();
            return docoob;
        }
        return null;
    }
}

