/*
 * Decompiled with CFR 0.152.
 */
package com.wm.dom;

import com.wm.dom.DOMExceptionImpl;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.ExternalEntity;
import com.wm.lang.xml.token.TokenException;
import com.wm.util.Name;
import java.io.IOException;
import org.w3c.dom.Entity;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class EntityImpl
extends ElementNode
implements Entity {
    private boolean expandedChildren = false;
    private String inputEncoding;
    private TypeInfo schemaTypeInfo;
    private com.wm.lang.xml.token.Entity wmEntity;
    private String xmlEncoding;
    private String xmlVersion;

    public EntityImpl(Document doc, com.wm.lang.xml.token.Entity ent) {
        super(doc, null, ent.getName());
        this.xmlVersion = doc.getXmlVersion();
        this.xmlEncoding = doc.getXmlEncoding();
        this.isComplete(true);
        this.wmEntity = ent;
        this.setReadOnly(true);
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        EntityImpl clone = new EntityImpl(this.getDocument(), this.wmEntity);
        if (deep) {
            clone.setReadOnly(false);
            for (Node node = (Node)this.getFirstChild(); node != null; node = (Node)node.getNextSibling()) {
                Node clonedChild = (Node)node.cloneNode(deep);
                clonedChild.isComplete(true);
                clone.addChild(clonedChild);
            }
            clone.setReadOnly(true);
        }
        clone.expandedChildren = this.expandedChildren;
        return clone;
    }

    private void expandChildren() {
        try {
            if (this.wmEntity == null || this.wmEntity instanceof ExternalEntity) {
                return;
            }
            this.setReadOnly(false);
            String expandedValue = this.wmEntity.getExpandedValue();
            if (expandedValue != null) {
                Document tempDoc = new Document(expandedValue, "", null, true, true);
                tempDoc.completeLoad();
                while (tempDoc.hasChildNodes()) {
                    Node kid = tempDoc.getFirstChildWm();
                    tempDoc.removeChild((org.w3c.dom.Node)kid);
                    this.appendChild(this.getDocument().importNode(kid, true));
                }
            }
            return;
        }
        catch (WMDocumentException ex) {
            throw new DOMExceptionImpl(15, ex.getMessage());
        }
        catch (TokenException ex) {
            throw new DOMExceptionImpl(15, ex.getMessage());
        }
        catch (IOException ex) {
            throw new DOMExceptionImpl(15, ex.getMessage());
        }
        finally {
            this.setReadOnly(true);
        }
    }

    public NodeList getChildNodes() {
        if (!this.expandedChildren) {
            this.expandChildren();
        }
        return super.getChildNodes();
    }

    public Node getClone() {
        return (Node)this.cloneNode(true);
    }

    public org.w3c.dom.Node getFirstChild() {
        if (!this.expandedChildren) {
            this.expandChildren();
        }
        return super.getFirstChild();
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public org.w3c.dom.Node getLastChild() {
        if (!this.expandedChildren) {
            this.expandChildren();
        }
        return super.getLastChild();
    }

    public String getNodeName() {
        Name nodeName = null;
        if (this.wmEntity != null) {
            nodeName = this.wmEntity.getName();
        }
        if (nodeName != null) {
            return nodeName.toString();
        }
        return null;
    }

    public short getNodeType() {
        return 6;
    }

    public String getNotationName() {
        if (this.wmEntity != null) {
            return this.wmEntity.getNotationName();
        }
        return null;
    }

    public String getPublicId() {
        if (this.wmEntity != null) {
            return this.wmEntity.getPublicID();
        }
        return null;
    }

    public TypeInfo getSchemaTypeInfo() {
        return this.schemaTypeInfo;
    }

    public String getSystemId() {
        if (this.wmEntity != null) {
            return this.wmEntity.getSystemID();
        }
        return null;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public boolean hasChildNodes() {
        if (!this.expandedChildren) {
            this.expandChildren();
        }
        return super.hasChildNodes();
    }

    protected void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    protected void setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
    }

    protected void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }
}

