/*
 * Decompiled with CFR 0.152.
 */
package com.wm.dom;

import com.wm.dom.DOMImplementationImpl;
import com.wm.dom.DocumentBuilderFactoryImpl;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.WMDocumentException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.DOMImplementation;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private DOMImplementation implementation = new DOMImplementationImpl();
    private DocumentBuilderFactoryImpl factory;

    public DocumentBuilderImpl(DocumentBuilderFactoryImpl fact) {
        this.factory = fact;
    }

    public org.w3c.dom.Document parse(InputSource inputSource) throws SAXException, IOException {
        try {
            int expandEntities = this.factory.isExpandEntityReferences() ? 1 : 2;
            Reader charStream = inputSource.getCharacterStream();
            Document doc = charStream != null ? new Document(charStream, inputSource.getSystemId(), inputSource.getEncoding(), expandEntities) : new Document(inputSource.getByteStream(), inputSource.getSystemId(), inputSource.getEncoding(), expandEntities);
            doc.completeLoad();
            return doc;
        }
        catch (WMDocumentException exception) {
            throw new SAXException(exception.getLocalizedMessage());
        }
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return false;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return false;
    }

    public boolean isIgnoringComments() {
        return false;
    }

    public boolean isCoalescing() {
        return false;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public org.w3c.dom.Document newDocument() {
        return new Document();
    }

    public DOMImplementation getDOMImplementation() {
        return this.implementation;
    }

    protected EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    protected ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

