/*
 * Decompiled with CFR 0.152.
 */
package com.wm.dom;

import com.wm.util.LocalizedIOException;
import com.wm.util.SpecifiedLocale;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.DOMException;

public class DOMExceptionImpl
extends DOMException
implements SpecifiedLocale {
    private static final long serialVersionUID = -8415793677071243819L;
    private String _details;
    private Throwable _exception;
    private String _key;
    private static final String BUNDLE_NAME = "com.wm.dom.resources.DOMMessageBundle";
    private static final String PROD_CODE = "ISC";
    private static ResourceBundle _defaultRb;

    public DOMExceptionImpl(short code) {
        super(code, "");
        this._key = this.getKey();
    }

    public DOMExceptionImpl(short code, String details) {
        super(code, "");
        this._details = details;
        this._key = this.getKey();
    }

    public DOMExceptionImpl(short code, Throwable ex) {
        super(code, "");
        this._exception = ex;
        this._key = this.getKey();
    }

    public String getMessage() {
        return this.getLocalizedMessage(this.getResourceBundle(Locale.getDefault()));
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(this.getResourceBundle(Locale.getDefault()));
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedMessage(this.getResourceBundle(locale));
    }

    private String getLocalizedMessage(ResourceBundle rb) {
        String text;
        StringBuffer msg = new StringBuffer("[ISC." + this._key + "] ");
        if (this._exception != null) {
            this._details = this._exception instanceof SpecifiedLocale ? ((SpecifiedLocale)((Object)this._exception)).getLocalizedMessage(rb.getLocale()) : this._exception.getLocalizedMessage();
        }
        if (this._details == null) {
            this._details = "";
        }
        try {
            text = rb.getString(this._key);
        }
        catch (MissingResourceException ex) {
            text = "Bundle:com.wm.dom.resources.DOMMessageBundle Key:" + this._key + " " + this._details;
        }
        catch (Throwable ex2) {
            text = "Bundle:com.wm.dom.resources.DOMMessageBundle Key:" + this._key + " " + this._details + " Exception:" + ex2.toString();
        }
        msg.append(text);
        return MessageFormat.format(msg.toString(), this._details);
    }

    private String getKey() {
        return "133." + this.code;
    }

    private synchronized ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb;
        boolean defaultLocale = false;
        if (Locale.getDefault().equals(locale)) {
            defaultLocale = true;
            if (_defaultRb != null) {
                return _defaultRb;
            }
        }
        if (!(rb = ResourceBundle.getBundle(BUNDLE_NAME, locale)).getLocale().getLanguage().equals(locale.getLanguage())) {
            rb = ResourceBundle.getBundle(BUNDLE_NAME, new Locale("", ""));
        }
        if (defaultLocale) {
            _defaultRb = rb;
        }
        return rb;
    }

    public static void main(String[] args) {
        DOMExceptionImpl ex;
        short i;
        Locale deutch = Locale.GERMAN;
        System.out.println("Starting all codes");
        for (i = 1; i < 16; i = (short)(i + 1)) {
            ex = new DOMExceptionImpl(i);
            System.out.println("getMessage          " + i + ":" + ex.getMessage());
            System.out.println("getLocalizedMessage " + i + ":" + ex.getLocalizedMessage());
            System.out.println("AUF Deutch          " + i + ":" + ex.getLocalizedMessage(deutch));
        }
        System.out.println("\n\nStarting all codes with Detail String");
        for (i = 1; i < 16; i = (short)(i + 1)) {
            ex = new DOMExceptionImpl(i, "Some details");
            System.out.println("getMessage          " + i + ":" + ex.getMessage());
        }
        Exception ex2 = new Exception("Exception Details");
        System.out.println("\n\nStarting all codes with Detail Exception");
        for (short i2 = 1; i2 < 16; i2 = (short)(i2 + 1)) {
            DOMExceptionImpl ex3 = new DOMExceptionImpl(i2, (Throwable)ex2);
            System.out.println("getMessage          " + i2 + ":" + ex3.getMessage());
        }
        LocalizedIOException ex3 = new LocalizedIOException("WebmExcp Details");
        System.out.println("\n\nStarting all codes with Detail WmException");
        for (short i3 = 1; i3 < 16; i3 = (short)(i3 + 1)) {
            DOMExceptionImpl ex4 = new DOMExceptionImpl(i3, (Throwable)ex3);
            System.out.println("getMessage          " + i3 + ":" + ex4.getMessage());
        }
    }
}

