/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.MInteger;
import com.wm.data.ValuesEmulatorKeysEnumerator;
import com.wm.data.ValuesEmulatorValueEnumerator;
import com.wm.util.Values;
import java.util.Enumeration;
import java.util.Vector;

public class ValuesEmulator {
    public static Object get(IData pipeline, String key) {
        Object val = null;
        IDataCursor item = pipeline.getCursor();
        if (item.first(key)) {
            val = item.getValue();
        }
        item.destroy();
        return val;
    }

    public static String getString(IData pipeline, String key) {
        Object o = ValuesEmulator.get(pipeline, key);
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static String getNonEmptyString(IData pipeline, String key) {
        String s = ValuesEmulator.getString(pipeline, key);
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    public static String[] getStringArray(IData pipeline, String key) {
        Object o = ValuesEmulator.get(pipeline, key);
        if (o instanceof String[]) {
            return (String[])o;
        }
        return null;
    }

    public static Values getValues(IData pipeline, String key) {
        Object o = ValuesEmulator.get(pipeline, key);
        if (o instanceof Values) {
            return (Values)o;
        }
        return null;
    }

    public static boolean getBoolean(IData pipeline, String key) {
        Object o = ValuesEmulator.get(pipeline, key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return new Boolean(o.toString());
        }
        return false;
    }

    public static int getInt(IData pipeline, String key) {
        return ValuesEmulator.getInt(pipeline, key, -1);
    }

    public static int getInt(IData pipeline, String key, int def) {
        Object o = ValuesEmulator.get(pipeline, key);
        if (o == null) {
            return def;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Object remove(IData pipeline, String key) {
        IDataCursor item = pipeline.getCursor();
        if (!item.first(key)) {
            return null;
        }
        Object res = item.getValue();
        item.delete();
        item.destroy();
        return res;
    }

    public static Object put(IDataCursor item, String key, Object value) {
        if (!item.first(key)) {
            item.last();
            item.insertAfter(key, value);
            return null;
        }
        Object res = item.getValue();
        item.setValue(value);
        return res;
    }

    public static Object put(IData pipeline, String key, Object value) {
        IDataCursor item = pipeline.getCursor();
        if (!item.first(key)) {
            item.last();
            item.insertAfter(key, value);
            item.destroy();
            return null;
        }
        Object res = item.getValue();
        item.setValue(value);
        item.destroy();
        return res;
    }

    public static Object put(IData pipeline, String key, int value) {
        return ValuesEmulator.put(pipeline, key, (Object)new MInteger(value));
    }

    public static int size(IData data) {
        int ret = 0;
        IDataCursor cursor = data.getCursor();
        while (cursor.next()) {
            ++ret;
        }
        cursor.destroy();
        return ret;
    }

    public static Enumeration keys(IData data) {
        return new ValuesEmulatorKeysEnumerator(data.getCursor());
    }

    public static Enumeration elements(IData data) {
        return new ValuesEmulatorValueEnumerator(data.getCursor());
    }

    public static String[] getKeys(IData data) {
        ValuesEmulatorKeysEnumerator enumerator = new ValuesEmulatorKeysEnumerator(data.getCursor());
        Vector<String> v = new Vector<String>();
        while (enumerator.hasMoreElements()) {
            String nextElement = (String)enumerator.nextElement();
            v.addElement(nextElement);
        }
        Object[] keyList = new String[v.size()];
        v.copyInto(keyList);
        return keyList;
    }
}

