/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.InvalidTreePathException;
import com.wm.data.TreePathToken;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class TreePath {
    private Vector tokens = new Vector();
    private boolean absolute = false;

    private TreePath(String path) throws InvalidTreePathException {
        this.parse(path);
    }

    public Enumeration getTokens() {
        return this.tokens.elements();
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    private void parse(String path) throws InvalidTreePathException {
        StringTokenizer st = new StringTokenizer(path, "/", true);
        boolean lastUp = false;
        int i = 0;
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            if (tk.equals("/")) {
                if (lastUp) {
                    lastUp = false;
                } else if (i == 0) {
                    this.absolute = true;
                } else {
                    this.tokens.addElement(new TreePathToken(2));
                }
            } else if (!tk.equals(".")) {
                if (tk.equals("..")) {
                    this.tokens.addElement(new TreePathToken(3));
                    lastUp = true;
                } else {
                    int idx = 1;
                    int ioff = tk.indexOf("[");
                    if (ioff > 0) {
                        if (!tk.endsWith("]")) {
                            throw new InvalidTreePathException("BAC.0007.0006", new String[]{tk});
                        }
                        idx = Integer.parseInt(tk.substring(ioff + 1, tk.length() - 1));
                        tk = tk.substring(0, ioff);
                    }
                    if (tk.length() == 0) {
                        tk = null;
                    }
                    this.tokens.addElement(new IndexToken(tk, idx));
                }
            }
            ++i;
        }
    }

    public static TreePath create(String path) throws InvalidTreePathException {
        return new TreePath(path);
    }

    public static TreePath safeCreate(String path) {
        try {
            return new TreePath(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    final class IndexToken
    extends TreePathToken {
        private String key;
        private int num;

        IndexToken(String key, int num) {
            super(1);
            this.key = key;
            this.num = num;
        }

        String getKey() {
            return this.key;
        }

        int getIndex() {
            return this.num;
        }
    }
}

