/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.BasicData;
import com.wm.data.DataElement;
import com.wm.data.DataException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.resources.BasicDataBundle;
import com.wm.util.List;
import java.util.ResourceBundle;

class OldDataCursor
implements IDataCursor {
    ResourceBundle bundle = BasicData.bundle;
    DataElement now;
    BasicData data;
    static final int ATBEGINNING = 0;
    static final int ATEND = 1;
    int nullInfo = 0;

    OldDataCursor(DataElement now, BasicData data) {
        this.init(now, data);
    }

    void init(DataElement now, BasicData data) {
        this.now = now;
        this.data = data;
        if (now == null) {
            this.nullInfo = 0;
        }
    }

    public void home() {
        this.now = null;
        this.nullInfo = 0;
    }

    public String getKey() {
        if (this.now == null) {
            return null;
        }
        return this.now.key;
    }

    public void setErrorMode(int m) {
    }

    public DataException getLastError() {
        return null;
    }

    public boolean hasMoreErrors() {
        return false;
    }

    public Object getValue() {
        if (this.now == null) {
            return null;
        }
        return this.now.value;
    }

    public void setKey(String key) {
        if (this.now == null) {
            return;
        }
        this.now.setKey(key);
    }

    public void setValue(Object value) {
        if (this.now == null) {
            return;
        }
        this.now.value = value;
    }

    public boolean delete() {
        if (this.now == null) {
            return false;
        }
        DataElement hold = this.now;
        boolean more = hold.next != null;
        this.now = more ? hold.next : hold.prev;
        hold.delete();
        return more;
    }

    public void insertBefore(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException(this.bundle.getString(BasicDataBundle.DATA_KEY_IS_NULL));
        }
        if (this.now != null) {
            this.now = this.now.insertBefore(key, value);
        } else {
            this.now = new DataElement(this.data, key, value);
            if (this.nullInfo == 0) {
                this.now.addToFront();
            } else {
                this.now.addToEnd();
            }
        }
    }

    public void insertAfter(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException(this.bundle.getString(BasicDataBundle.DATA_KEY_IS_NULL));
        }
        if (this.now != null) {
            this.now = this.now.insertAfter(key, value);
        } else {
            this.now = new DataElement(this.data, key, value);
            if (this.nullInfo == 0) {
                this.now.addToFront();
            } else {
                this.now.addToEnd();
            }
        }
    }

    public IData insertDataBefore(String key) {
        if (key == null) {
            throw new IllegalArgumentException(this.bundle.getString(BasicDataBundle.DATA_KEY_IS_NULL));
        }
        IData nd = BasicData.create();
        this.insertBefore(key, nd);
        return nd;
    }

    public IData insertDataAfter(String key) {
        if (key == null) {
            throw new IllegalArgumentException(this.bundle.getString(BasicDataBundle.DATA_KEY_IS_NULL));
        }
        IData nd = BasicData.create();
        this.insertAfter(key, nd);
        return nd;
    }

    public boolean next() {
        if (this.now == null) {
            if (this.nullInfo != 0) {
                return false;
            }
            this.now = this.data.first;
        } else {
            this.now = this.now.next;
            if (this.now == null) {
                this.nullInfo = 1;
            }
        }
        return this.now != null;
    }

    public boolean next(String key) {
        DataElement walk = this.now == null ? (this.nullInfo == 0 ? this.data.first : null) : this.now.next;
        if (walk == null) {
            return false;
        }
        while (walk != null) {
            if (walk.key == key || walk.key.equals(key)) {
                this.now = walk;
                return true;
            }
            walk = walk.next;
        }
        this.nullInfo = 1;
        return false;
    }

    public boolean previous() {
        if (this.now == null) {
            if (this.nullInfo == 1) {
                this.now = this.data.last;
            }
        } else {
            this.now = this.now.prev;
        }
        if (this.now == null) {
            this.nullInfo = 0;
        }
        return this.now != null;
    }

    public boolean previous(String key) {
        DataElement walk = this.now == null ? (this.nullInfo == 1 ? this.data.last : null) : this.now.prev;
        while (walk != null) {
            if (walk.key == key || walk.key.equals(key)) {
                this.now = walk;
                return true;
            }
            walk = walk.prev;
        }
        return false;
    }

    public boolean first() {
        this.now = this.data.first;
        if (this.now == null) {
            this.nullInfo = 0;
        }
        return this.now != null;
    }

    public boolean last() {
        this.now = this.data.last;
        if (this.now == null) {
            this.nullInfo = 1;
        }
        return this.now != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        BasicData basicData = this.data;
        synchronized (basicData) {
            if (this.data.oldHashCursors == null) {
                this.data.oldHashCursors = new List();
            } else if (this.data.oldHashCursors.contains(this)) {
                return;
            }
            this.now = null;
            this.data.oldHashCursors.addElement(this);
        }
    }

    public boolean hasMoreData() {
        if (this.now == null) {
            return this.nullInfo == 0 && this.data.first != null;
        }
        return this.now.next != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataCursor getCursorClone() {
        OldDataCursor ret = null;
        if (this.data.oldHashCursors != null) {
            List list = this.data.oldHashCursors;
            synchronized (list) {
                if (this.data.oldHashCursors.size() > 0) {
                    ret = (OldDataCursor)this.data.oldHashCursors.removeLastElement();
                }
            }
        }
        if (ret == null) {
            ret = new OldDataCursor(this.now, this.data);
        } else {
            ret.init(this.now, this.data);
        }
        return ret;
    }

    public String toString() {
        if (this.now == null) {
            return this.bundle.getString(BasicDataBundle.IDATACURSOR_NULL);
        }
        return this.bundle.getString(BasicDataBundle.IDATACURSOR) + ":" + this.now.key;
    }

    public boolean first(String key) {
        this.first();
        if (this.getKey() == null) {
            return false;
        }
        do {
            if (!this.getKey().equals(key)) continue;
            return true;
        } while (this.next());
        return false;
    }

    public boolean last(String key) {
        this.last();
        if (this.getKey() == null) {
            return false;
        }
        do {
            if (!this.getKey().equals(key)) continue;
            return true;
        } while (this.previous());
        return false;
    }
}

