/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.util.coder.IDataCodable;
import java.io.Serializable;

public class MBoolean
implements IDataCodable,
Serializable {
    public static final MBoolean TRUE = new MBoolean(true);
    public static final MBoolean FALSE = new MBoolean(false);
    private boolean value;
    private static final String KEY_MBOOLEAN = "MBoolean";

    public MBoolean() {
        this.value = false;
    }

    public MBoolean(boolean value) {
        this.value = value;
    }

    public MBoolean(String s) {
        this(MBoolean.toBoolean(s));
    }

    public boolean booleanValue() {
        return this.value;
    }

    public static MBoolean valueOf(String s) {
        return new MBoolean(MBoolean.toBoolean(s));
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MBoolean) {
            return this.value == ((MBoolean)obj).booleanValue();
        }
        return false;
    }

    public static boolean getBoolean(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(name);
        }
        return MBoolean.toBoolean(System.getProperty(name));
    }

    private static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }

    public void setValue(boolean b) {
        this.value = b;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setFromData(IData id) {
        this.setIData(id);
    }

    public IData getAsData() {
        return this.getIData();
    }

    public void setIData(IData id) {
        IDataCursor idhc = id.getCursor();
        String val = "false";
        if (idhc.first(KEY_MBOOLEAN)) {
            val = (String)idhc.getValue();
        }
        this.setValue(MBoolean.toBoolean(val));
    }

    public IData getIData() {
        IData id = IDataFactory.create(1);
        IDataCursor idc = id.getCursor();
        idc.insertAfter(KEY_MBOOLEAN, this.toString());
        idc.destroy();
        return id;
    }
}

