/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.DataCursorWrapper;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataIndexCursor;

public class IndexCursor
extends DataCursorWrapper
implements IDataIndexCursor {
    int index = -1;
    int count = 0;

    private IndexCursor(IDataCursor cursor) {
        super(cursor);
        while (cursor.next()) {
            ++this.count;
        }
        cursor.home();
    }

    public boolean delete() {
        if (this.count < 0) {
            return false;
        }
        if (!this.hasMoreData()) {
            --this.index;
        }
        --this.count;
        return super.delete();
    }

    public void insertBefore(String key, Object value) {
        ++this.count;
        if (this.index < 0) {
            this.index = 0;
        }
        super.insertBefore(key, value);
    }

    public void insertAfter(String key, Object value) {
        ++this.index;
        ++this.count;
        super.insertAfter(key, value);
    }

    public IData insertDataBefore(String key) {
        ++this.count;
        if (this.index < 0) {
            this.index = 0;
        }
        return super.insertDataBefore(key);
    }

    public IData insertDataAfter(String key) {
        ++this.count;
        ++this.index;
        return super.insertDataAfter(key);
    }

    public boolean next() {
        boolean b = super.next();
        if (b) {
            ++this.index;
        }
        return b;
    }

    public boolean previous() {
        boolean b = super.previous();
        if (b) {
            --this.index;
        }
        return b;
    }

    public boolean first() {
        boolean b = super.first();
        if (b) {
            this.index = this.getKey() != null ? 0 : -1;
        }
        return b;
    }

    public boolean last() {
        boolean b = super.last();
        if (b) {
            this.index = this.count - 1;
        }
        return b;
    }

    public IDataCursor getCursorClone() {
        IndexCursor c = new IndexCursor(super.getCursorClone());
        c.index = this.index;
        c.count = this.count;
        return c;
    }

    public boolean seek(int idx) {
        if (idx >= this.count || idx < 0 || this.count <= 0) {
            return false;
        }
        if (idx > this.index) {
            while (idx > this.index) {
                this.next();
            }
        } else {
            while (idx < this.index) {
                this.previous();
            }
        }
        return true;
    }

    public int count() {
        return this.count;
    }

    public static IDataIndexCursor create(IDataCursor cursor) {
        return new IndexCursor(cursor);
    }
}

