/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.HashCursor;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataPortable;
import com.wm.data.IDataTreeCursor;
import com.wm.data.IndexCursor;
import com.wm.data.TreeCursor;
import com.wm.data.resources.BasicDataBundle;
import com.wm.util.coder.IDataCodable;
import com.wm.util.data.MemData;
import java.io.Serializable;
import java.util.ResourceBundle;

public class ISMemDataImpl
extends MemData
implements Serializable {
    static final long serialVersionUID = 932528005360284573L;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com.wm.data.resources.BasicDataBundle");
    protected transient boolean recursed = false;

    public static IData create() {
        return new ISMemDataImpl();
    }

    public MemData newInstance() {
        return new ISMemDataImpl();
    }

    public IDataHashCursor getHashCursor() {
        return HashCursor.create(this.getCursor());
    }

    public IDataIndexCursor getIndexCursor() {
        return IndexCursor.create(this.getCursor());
    }

    public IDataTreeCursor getTreeCursor() {
        return TreeCursor.create(this.getCursor());
    }

    public IData copy() {
        ISMemDataImpl copy = new ISMemDataImpl();
        IDataCursor dcThis = this.getCursor();
        IDataCursor dcCopy = copy.getCursor();
        while (dcThis.next()) {
            dcCopy.insertAfter(dcThis.getKey(), dcThis.getValue());
        }
        return copy;
    }

    public String toString() {
        if (this.recursed) {
            String recursedMsg = bundle.getString(BasicDataBundle.BASIC_DATA_OBJECT_RECURSED);
            return " >>> " + recursedMsg + " <<< ";
        }
        this.recursed = true;
        IDataCursor dc = this.getCursor();
        StringBuffer sb = new StringBuffer();
        sb.append(">>>BasicData:");
        while (dc.next()) {
            sb.append(dc.getKey());
            sb.append("=");
            Object obj = dc.getValue();
            if (obj instanceof Object[]) {
                Object[] arr = (Object[])obj;
                StringBuffer ab = new StringBuffer();
                for (int j = 0; j < arr.length; ++j) {
                    ab.append("[" + j + "]" + this.idataObject(arr[j]) + (j < arr.length - 1 ? "," : ""));
                }
                obj = ab.toString();
            }
            sb.append(this.idataObject(obj));
            if (!dc.hasMoreData()) continue;
            sb.append(",");
        }
        sb.append("<<<");
        this.recursed = false;
        return sb.toString();
    }

    private Object idataObject(Object value) {
        if (!(value instanceof IData)) {
            if (value instanceof IDataCodable) {
                value = ((IDataCodable)value).getIData();
            } else if (value instanceof IDataPortable) {
                value = ((IDataPortable)value).getAsData();
            }
        }
        return value;
    }
}

