/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.util.List;
import com.wm.util.coder.DeepCloneReferenceManager;
import com.wm.util.coder.IDataBinCoder;
import com.wm.util.coder.IDataCodable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class IDataUtil {
    public static final int COMPARE_TYPE_COLLATION = 0;
    public static final int COMPARE_TYPE_NUMERIC = 1;
    public static final int COMPARE_TYPE_EQUALS = 2;
    public static final int COMPARE_TYPE_TIME = 3;
    public static final int DIRECTION_ASCENDING = 0;
    public static final int DIRECTION_DESCENDING = 1;
    static final boolean debug = false;
    static final boolean debugEquals = false;

    public static IData create(Object[][] data) {
        IData nd = IDataFactory.create();
        IDataCursor idc = nd.getCursor();
        for (int i = 0; i < data.length; ++i) {
            idc.insertAfter((String)data[i][0], data[i][1]);
        }
        idc.destroy();
        return nd;
    }

    public static IData getIData(IDataCursor idc) {
        Object o = idc.getValue();
        if (o instanceof IData) {
            return (IData)o;
        }
        return null;
    }

    public static String getString(IDataCursor idc) {
        Object o = idc.getValue();
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static String[] getStringArray(IDataCursor idc) {
        Object o = idc.getValue();
        if (o instanceof String[]) {
            return (String[])o;
        }
        return null;
    }

    public static String[][] getStringTable(IDataCursor idc) {
        Object o = idc.getValue();
        if (o instanceof String[][]) {
            return (String[][])o;
        }
        return null;
    }

    public static boolean getBoolean(IDataCursor idc) {
        Object o = idc.getValue();
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return new Boolean(o.toString());
        }
        return false;
    }

    public static boolean getBoolean(IDataCursor cursor, String key) {
        Object value = IDataUtil.get(cursor, key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return new Boolean(value.toString());
        }
        return false;
    }

    public static boolean getBoolean(IDataCursor cursor, String key, boolean def) {
        Object value = IDataUtil.get(cursor, key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return new Boolean(value.toString());
        }
        return def;
    }

    public static int getInt(IDataCursor idc, int def) {
        Object o = idc.getValue();
        if (o == null) {
            return def;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static int getInt(IDataCursor idc) {
        return IDataUtil.getInt(idc, -1);
    }

    public static String[][] getStringTable(IDataCursor cursor, String key) {
        Object value = IDataUtil.get(cursor, key);
        if (value instanceof String[][]) {
            return (String[][])value;
        }
        return null;
    }

    public static Object[] getObjectArray(IDataCursor cursor, String key) {
        Object value = IDataUtil.get(cursor, key);
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        return null;
    }

    public static void copy(IData src, IData dst) {
        if (src == null || dst == null || src == dst) {
            return;
        }
        IDataCursor srcC = src.getCursor();
        IDataCursor dstC = dst.getCursor();
        dstC.first();
        while (srcC.next()) {
            dstC.insertAfter(srcC.getKey(), srcC.getValue());
        }
        srcC.destroy();
        dstC.destroy();
    }

    public static void append(IData src, IData dst) {
        if (src == null || dst == null || src == dst) {
            return;
        }
        IDataCursor srcC = src.getCursor();
        IDataCursor dstC = dst.getCursor();
        dstC.last();
        while (srcC.next()) {
            dstC.insertAfter(srcC.getKey(), srcC.getValue());
        }
        srcC.destroy();
        dstC.destroy();
    }

    public static void merge(IData src, IData dst) {
        if (src == null || dst == null || src == dst) {
            return;
        }
        IDataCursor srcC = src.getCursor();
        if (!srcC.hasMoreData()) {
            srcC.destroy();
            return;
        }
        IDataCursor dstC = dst.getCursor();
        if (!dstC.first()) {
            IDataUtil.append(src, dst);
            dstC.destroy();
            return;
        }
        IData srcClone = IDataUtil.clone(src);
        srcC = srcClone.getCursor();
        do {
            String key;
            if (!srcC.first(key = dstC.getKey())) continue;
            dstC.setValue(srcC.getValue());
            srcC.delete();
        } while (dstC.next());
        dstC.destroy();
        srcC.destroy();
        IDataUtil.append(srcClone, dst);
    }

    public static IData clone(IData src) {
        if (src instanceof Cloneable) {
            try {
                Method clone = src.getClass().getMethod("clone", null);
                return (IData)clone.invoke((Object)src, (Object[])null);
            }
            catch (Exception e) {
                return null;
            }
        }
        IData clone = null;
        try {
            Method create = src.getClass().getMethod("create", null);
            clone = (IData)create.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            clone = IDataFactory.create();
        }
        IDataUtil.append(src, clone);
        return clone;
    }

    public static IData deepClone(IData src) throws IOException {
        IData clone = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        DeepCloneReferenceManager dcrm = new DeepCloneReferenceManager();
        IDataBinCoder coder = new IDataBinCoder(dcrm);
        coder.encode(baos, src);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        clone = coder.decode(bais);
        dcrm.cleanup();
        return clone;
    }

    public static IData[] sortIDataArrayByKey(IData[] dataArray, String key, int compareType, String pattern, boolean reverse) {
        if (dataArray == null || key == null) {
            return null;
        }
        if (compareType == 3) {
            SimpleDateFormat dateFormat = null;
            String timePattern = pattern == null ? "MM/dd/yyyy hh:mm:ss a" : pattern;
            dateFormat = new SimpleDateFormat(timePattern);
            TimeComparator tc = new TimeComparator(dateFormat, key);
            Arrays.sort(dataArray, tc);
        } else if (compareType == 0) {
            StringComparator sc = new StringComparator(key);
            Arrays.sort(dataArray, sc);
        } else {
            return null;
        }
        if (reverse) {
            int halfLen = dataArray.length / 2;
            int len = dataArray.length;
            IData temp = null;
            for (int i = 0; i < halfLen; ++i) {
                temp = dataArray[i];
                dataArray[i] = dataArray[len - 1 - i];
                dataArray[len - 1 - i] = temp;
            }
        }
        return dataArray;
    }

    public static IData[] sortIDataArrayByKey(IData[] dataArray, String key, int compareType, boolean reverse) {
        String pattern = System.getProperty("watt.server.dateStampFmt");
        return IDataUtil.sortIDataArrayByKey(dataArray, key, compareType, pattern, reverse);
    }

    public static boolean equals(IData d1, IData d2) {
        if (d1 == null || d2 == null) {
            return d1 == d2;
        }
        boolean ret = true;
        IDataCursor c1 = d1.getCursor();
        IDataCursor c2 = d2.getCursor();
        boolean b1 = c1.next();
        boolean b2 = c2.next();
        while (b1) {
            if (!b2) {
                ret = false;
                break;
            }
            String k1 = c1.getKey();
            String k2 = c2.getKey();
            if (k2 == null || !k1.equals(k2)) {
                ret = false;
                break;
            }
            Object o1 = c1.getValue();
            Object o2 = c2.getValue();
            if (o1 == null || o2 == null) {
                if (o1 != o2) {
                    ret = false;
                    break;
                }
                b1 = c1.next();
                b2 = c2.next();
                continue;
            }
            if (!IDataUtil._equals(o1, o2)) {
                ret = false;
                break;
            }
            b1 = c1.next();
            if (b1 == (b2 = c2.next())) continue;
            ret = false;
            break;
        }
        if (b2) {
            ret = false;
        }
        c1.destroy();
        c2.destroy();
        return ret;
    }

    private static boolean _equals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        if (o1 instanceof Object[][]) {
            if (!(o2 instanceof Object[][])) {
                return false;
            }
            Object[][] oo1 = (Object[][])o1;
            Object[][] oo2 = (Object[][])o2;
            if (oo1.length != oo2.length) {
                return false;
            }
            if (oo1.length != oo2.length) {
                return false;
            }
            for (int j = 0; j < oo1.length; ++j) {
                if (oo1[j].length != oo2[j].length) {
                    return false;
                }
                for (int i = 0; i < oo1[j].length; ++i) {
                    if (IDataUtil._equals(oo1[j][i], oo2[j][i])) continue;
                    return false;
                }
            }
            return true;
        }
        if (o1 instanceof Object[]) {
            if (!(o2 instanceof Object[])) {
                return false;
            }
            Object[] oo1 = (Object[])o1;
            Object[] oo2 = (Object[])o2;
            if (oo1.length != oo2.length) {
                return false;
            }
            for (int i = 0; i < oo1.length; ++i) {
                if (IDataUtil._equals(oo1[i], oo2[i])) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof IData) {
            if (o2 instanceof IDataCodable) {
                return IDataUtil.equals((IData)o1, ((IDataCodable)o2).getIData());
            }
            if (o2 instanceof IDataPortable) {
                return IDataUtil.equals((IData)o1, ((IDataPortable)o2).getAsData());
            }
            if (o2 instanceof IData) {
                return IDataUtil.equals((IData)o1, (IData)o2);
            }
            return false;
        }
        if (o1 instanceof Vector) {
            if (!(o2 instanceof Vector)) {
                return false;
            }
            Vector v1 = (Vector)o1;
            Vector v2 = (Vector)o2;
            if (v1.size() != v2.size()) {
                return false;
            }
            Enumeration e1 = v1.elements();
            Enumeration e2 = v2.elements();
            while (e1.hasMoreElements()) {
                if (IDataUtil._equals(e1.nextElement(), e2.nextElement())) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof List) {
            if (!(o2 instanceof List)) {
                return false;
            }
            List v1 = (List)o1;
            List v2 = (List)o2;
            if (v1.size() != v2.size()) {
                return false;
            }
            Enumeration e1 = v1.elements();
            Enumeration e2 = v2.elements();
            while (e1.hasMoreElements()) {
                if (IDataUtil._equals(e1.nextElement(), e2.nextElement())) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof IDataCodable) {
            if (o2 instanceof IData) {
                return IDataUtil.equals(((IDataCodable)o1).getIData(), (IData)o2);
            }
            if (o2 instanceof IDataPortable) {
                return IDataUtil.equals(((IDataCodable)o1).getIData(), ((IDataPortable)o2).getAsData());
            }
            if (!(o2 instanceof IDataCodable)) {
                return false;
            }
            return IDataUtil.equals(((IDataCodable)o1).getIData(), ((IDataCodable)o2).getIData());
        }
        if (o1 instanceof IDataPortable) {
            if (o2 instanceof IData) {
                return IDataUtil.equals(((IDataPortable)o1).getAsData(), (IData)o2);
            }
            if (o2 instanceof IDataCodable) {
                return IDataUtil.equals(((IDataPortable)o1).getAsData(), ((IDataCodable)o2).getIData());
            }
            if (!(o2 instanceof IDataPortable)) {
                return false;
            }
            return IDataUtil.equals(((IDataPortable)o1).getAsData(), ((IDataPortable)o2).getAsData());
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            byte[] b1 = (byte[])o1;
            byte[] b2 = (byte[])o2;
            if (b1.length != b2.length) {
                return false;
            }
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            int[] b1 = (int[])o1;
            int[] b2 = (int[])o2;
            if (b1.length != b2.length) {
                return false;
            }
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    public static void put(IDataCursor cursor, String key, Object value) {
        if (cursor.first(key)) {
            cursor.setValue(value);
        } else {
            cursor.last();
            cursor.insertAfter(key, value);
        }
    }

    public static void putInt(IDataCursor cursor, String key, int value) {
        IDataUtil.put(cursor, key, Integer.toString(value));
    }

    public static Object get(IDataCursor cursor, String key) {
        Object value = null;
        if (cursor.first(key)) {
            value = cursor.getValue();
        }
        return value;
    }

    public static String getString(IDataCursor cursor, String key) {
        Object value = IDataUtil.get(cursor, key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String[] getStringArray(IDataCursor cursor, String key) {
        Object value = IDataUtil.get(cursor, key);
        if (value instanceof String[]) {
            return (String[])value;
        }
        return null;
    }

    public static IData getIData(IDataCursor cursor, String key) {
        Object value = IDataUtil.get(cursor, key);
        if (value instanceof IData) {
            return (IData)value;
        }
        return null;
    }

    public static IData[] getIDataArray(IDataCursor cursor, String key) {
        Object value = IDataUtil.get(cursor, key);
        if (value instanceof IData[]) {
            return (IData[])value;
        }
        return null;
    }

    public static int getInt(IDataCursor cursor, String key, int def) {
        Object value = IDataUtil.get(cursor, key);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static long getLong(IDataCursor cursor, String key, long def) {
        Object value = IDataUtil.get(cursor, key);
        if (value == null) {
            return def;
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static void remove(IDataCursor cursor, String key) {
        if (cursor.first(key)) {
            cursor.delete();
        }
    }

    public static int size(IDataCursor cursor) {
        int count = 0;
        if (cursor.first()) {
            do {
                ++count;
            } while (cursor.next());
        }
        return count;
    }

    public static boolean contains(IDataCursor cursor, Object value) {
        if (cursor.first()) {
            do {
                Object cursorValue = cursor.getValue();
                if ((value == null || !value.equals(cursorValue)) && (value != null || cursorValue != null)) continue;
                return true;
            } while (cursor.next());
        }
        return false;
    }

    public static void main(String[] args) {
        IData pipeline = IDataFactory.create();
        IDataCursor cursor = pipeline.getCursor();
        IDataUtil.put(cursor, "a", "a");
        IDataUtil.put(cursor, "b", "b");
        IDataUtil.put(cursor, "c", "c");
        IDataUtil.put(cursor, "a", "d");
        IDataUtil.put(cursor, "d", "d");
        IDataUtil.remove(cursor, "d");
        IDataUtil.remove(cursor, null);
        IDataUtil.put(cursor, "int", "1232");
        System.out.println(IDataUtil.getInt(cursor, "int", -1));
        System.out.println(pipeline.toString());
        System.out.println(IDataUtil.size(cursor));
    }

    private static class TimeComparator
    implements Comparator {
        SimpleDateFormat sdf = null;
        String compareKey = null;

        TimeComparator(SimpleDateFormat format, String key) {
            this.sdf = format;
            this.compareKey = key;
        }

        public int compare(Object o1, Object o2) {
            long time1 = this.getDateMillis(o1);
            long time2 = this.getDateMillis(o2);
            int result = 0;
            if (time1 < time2) {
                result = -1;
            } else if (time1 > time2) {
                result = 1;
            }
            return result;
        }

        private long getDateMillis(Object obj) {
            long dateMillis = 0L;
            IData idata = null;
            if (!(obj instanceof IData)) {
                throw new ClassCastException("Invalid Object type");
            }
            idata = (IData)obj;
            IDataCursor idc = idata.getCursor();
            String sdate = null;
            boolean found = idc.first(this.compareKey);
            if (found) {
                sdate = IDataUtil.getString(idc);
            }
            if (sdate == null) {
                return Long.MAX_VALUE;
            }
            Date d = null;
            try {
                d = this.sdf.parse(sdate);
                dateMillis = d.getTime();
            }
            catch (ParseException pex) {
                try {
                    this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.s z");
                    d = this.sdf.parse(sdate);
                    dateMillis = d.getTime();
                }
                catch (ParseException x) {
                    throw new RuntimeException(x.getLocalizedMessage());
                }
            }
            idc.destroy();
            return dateMillis;
        }
    }

    private static class StringComparator
    implements Comparator {
        String compareKey = null;

        StringComparator(String key) {
            this.compareKey = key;
        }

        public int compare(Object o1, Object o2) {
            String str1 = this.getComparable(o1);
            String str2 = this.getComparable(o2);
            if (str1 == null || str2 == null) {
                return -1;
            }
            return str1.compareTo(str2);
        }

        private String getComparable(Object obj) {
            String comparable = null;
            IData idata = null;
            if (!(obj instanceof IData)) {
                throw new ClassCastException("Invalid Object type");
            }
            idata = (IData)obj;
            IDataCursor idc = idata.getCursor();
            boolean found = idc.first(this.compareKey);
            if (found) {
                comparable = IDataUtil.getString(idc);
            }
            return comparable;
        }
    }
}

