/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.BasicData;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.ISMemDataImpl;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class IDataFactory {
    static final String REVERT_TO_BASIC_DATA_PROPERTY = "watt.server.data.revertToBasic";
    private static final boolean RevertToBasicData;
    private static Hashtable registry;

    public static final IData create() {
        if (RevertToBasicData) {
            return BasicData.create();
        }
        return ISMemDataImpl.create();
    }

    public static final IData create(int size) {
        if (RevertToBasicData) {
            return BasicData.create();
        }
        return ISMemDataImpl.create();
    }

    public static final IData create(Object[][] values) {
        IData idata = IDataFactory.create();
        IDataCursor c = idata.getCursor();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].length != 2 || values[i][1] == null) continue;
            c.insertAfter((String)values[i][0], values[i][1]);
        }
        c.destroy();
        return idata;
    }

    public static final IData create(String name) throws Exception {
        try {
            String className = (String)registry.get(name);
            Class<?> dataClass = Class.forName(className);
            Method create = dataClass.getMethod("create", null);
            return (IData)create.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            System.out.println("Cannot find class: " + name);
            throw e;
        }
    }

    public static final void register(String name, String className) throws Exception {
        if (registry.containsKey(name)) {
            throw new Exception("The name= '" + name + "' for the class '" + className + "' has already been used.");
        }
        registry.put(name, className);
    }

    static {
        registry = new Hashtable(10);
        registry.put("ISMemDataImpl", "com.wm.data.ISMemDataImpl");
        registry.put("ISMemData", "com.wm.data.ISMemDataImpl");
        registry.put("BasicData", "com.wm.data.BasicData");
        RevertToBasicData = Boolean.getBoolean(REVERT_TO_BASIC_DATA_PROPERTY);
    }
}

