/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.DataException;
import com.wm.data.FixedData;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataIndexCursor;

final class FixedDataCursor
implements IDataIndexCursor {
    private static final boolean _debug = false;
    FixedData id;
    int index;

    FixedDataCursor(FixedData id) {
        this.id = id;
        this.index = -1;
    }

    boolean keyMatch(String key) {
        if (key == null) {
            this.id.illegal("illegal null key");
        }
        if (this.getKey().equals(key)) {
            return true;
        }
        for (int i = 0; i < this.id.data.length; ++i) {
            if (!this.id.data[i][0].equals(key)) continue;
            this.index = i;
            return true;
        }
        return false;
    }

    public void setErrorMode(int m) {
    }

    public DataException getLastError() {
        return null;
    }

    public boolean hasMoreErrors() {
        return false;
    }

    public void home() {
        this.index = -1;
    }

    public String getKey() {
        String ret = this.index < 0 || this.index > this.id.data.length ? null : this.id.data[this.index][0].toString();
        return ret;
    }

    public Object getValue() {
        Object ret = this.index < 0 || this.index > this.id.data.length ? null : this.id.data[this.index][1];
        return ret;
    }

    public void setKey(String key) {
        if (key == null) {
            this.id.illegal("Null keys not supported");
        }
        this.id.data[this.index][0] = key;
    }

    public void setValue(Object value) {
        this.id.data[this.index][1] = value;
    }

    public boolean delete() {
        this.id.illegal("FixedData does not support delete");
        return false;
    }

    public void insertBefore(String key, Object value) {
        this.previous();
        if (this.keyMatch(key)) {
            this.setValue(value);
        }
    }

    public void insertAfter(String key, Object value) {
        this.next();
        if (this.keyMatch(key)) {
            this.setValue(value);
        }
    }

    public IData insertDataBefore(String key) {
        this.previous();
        if (this.keyMatch(key)) {
            return (IData)this.getValue();
        }
        return null;
    }

    public IData insertDataAfter(String key) {
        this.next();
        if (this.keyMatch(key)) {
            return (IData)this.getValue();
        }
        return null;
    }

    public boolean next() {
        boolean ret;
        if (this.hasMoreData()) {
            ++this.index;
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean first(String key) {
        boolean ret = this._next(-1, key);
        return ret;
    }

    public boolean next(String key) {
        boolean ret = this._next(this.index, key);
        return ret;
    }

    private boolean _next(int start, String key) {
        if (key == null) {
            this.id.illegal("illegal null key");
        }
        for (int i = start + 1; i < this.id.data.length; ++i) {
            if (!this.id.data[i][0].equals(key)) continue;
            this.index = i;
            return true;
        }
        return false;
    }

    public boolean last(String key) {
        boolean ret = this._previous(-1, key);
        return ret;
    }

    public boolean previous(String key) {
        return this._previous(this.index, key);
    }

    private boolean _previous(int start, String key) {
        if (key == null) {
            this.id.illegal("illegal null key");
        }
        for (int i = start - 1; i >= 0; --i) {
            if (!this.id.data[i][0].equals(key)) continue;
            this.index = i;
            return true;
        }
        return false;
    }

    public boolean previous() {
        boolean ret;
        if (this.index > 0) {
            --this.index;
            ret = true;
        } else {
            this.index = this.id.data.length - 1;
            ret = this.index >= 0;
        }
        return ret;
    }

    public boolean first() {
        this.index = this.id.data.length > 0 ? 0 : -1;
        boolean ret = this.index >= 0;
        return ret;
    }

    public boolean last() {
        this.index = this.id.data.length - 1;
        boolean ret = this.index >= 0;
        return ret;
    }

    public boolean hasMoreData() {
        boolean ret = this.index + 1 < this.id.data.length;
        return ret;
    }

    public void destroy() {
    }

    public IDataCursor getCursorClone() {
        FixedDataCursor c = new FixedDataCursor(this.id);
        c.index = this.index;
        return c;
    }

    public boolean seek(int index) {
        if (index < 0 || index > this.id.data.length) {
            this.id.illegal("index of of bounds: " + index);
        }
        this.index = index;
        return true;
    }

    public int count() {
        return this.id.data.length;
    }
}

