/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.DataSharedCursorEmulator;
import com.wm.data.FixedDataCursor;
import com.wm.data.HashCursor;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataSharedCursor;
import com.wm.data.IDataTreeCursor;
import com.wm.data.TreeCursor;
import java.io.Serializable;

public abstract class FixedData
implements IData,
Cloneable,
Serializable {
    private static final boolean _debug = false;
    Object[][] data;
    int _idx;

    protected FixedData() {
    }

    protected FixedData(Object[][] data) {
        this.init(data);
    }

    public final void init(Object[][] data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this._idx = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].length != 2) {
                this.illegal("data rows must be 2 wide");
            }
            if (data[i][0] != null) continue;
            this.illegal("keys cannot be null");
        }
        this.data = data;
    }

    public final int nextID() {
        return this._idx++;
    }

    void illegal(String msg) throws IllegalArgumentException {
        throw new IllegalArgumentException(msg);
    }

    public final Object get(int index) {
        return this.data[index][1];
    }

    public final void set(int index, Object val) {
        this.data[index][1] = val;
    }

    protected final Object get(String key) {
        int index = FixedData.indexOf(this.data, key);
        if (index > -1) {
            return this.data[index][1];
        }
        return null;
    }

    protected final void set(String key, Object val) {
        int index = FixedData.indexOf(this.data, key);
        if (index > -1) {
            this.data[index][1] = val;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(">>>FixedData:");
        if (this.data != null) {
            for (int i = 0; i < this.data.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.data[i][0]);
                sb.append("=");
                sb.append(this.data[i][1]);
            }
        }
        sb.append("<<<");
        return sb.toString();
    }

    private static final int indexOf(Object[][] data, String key) {
        for (int i = 0; i < data.length; ++i) {
            if (((String)data[i][0]).intern() != key.intern()) continue;
            return i;
        }
        return -1;
    }

    public final IDataCursor getCursor() {
        return new FixedDataCursor(this);
    }

    public final IDataIndexCursor getIndexCursor() {
        return new FixedDataCursor(this);
    }

    public final IDataTreeCursor getTreeCursor() {
        return TreeCursor.create(this.getCursor());
    }

    public final IDataHashCursor getHashCursor() {
        return HashCursor.create(this.getCursor());
    }

    public final IDataSharedCursor getSharedCursor() {
        return DataSharedCursorEmulator.create(this.getCursor());
    }

    public static Object[][] merge(Object[][] d1, Object[][] d2) {
        int i;
        int d1l = d1.length;
        int d2l = d2.length;
        int tl = d1l + d2l;
        Object[][] d3 = new Object[tl][2];
        for (i = 0; i < d1l; ++i) {
            d3[i][0] = d1[i][0];
            d3[i][1] = d1[i][1];
        }
        for (i = 0; i < d2l; ++i) {
            d3[i + d1l][0] = d2[i][0];
            d3[i + d1l][1] = d2[i][1];
        }
        return d3;
    }

    protected static int getLastIndex() {
        return -1;
    }

    protected static Object[][] createData(int size) {
        return new Object[size][2];
    }

    public Object clone() {
        try {
            FixedData clone = (FixedData)super.clone();
            clone.data = new Object[this.data.length][2];
            for (int i = 0; i < this.data.length; ++i) {
                clone.data[i][0] = this.data[i][0];
                clone.data[i][1] = this.data[i][1];
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

