/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.DataException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.TreePath;
import com.wm.data.TreePathToken;
import java.util.Enumeration;
import java.util.Stack;

public class DataTreeCursor
implements IDataCursor {
    private transient IDataCursor cursor;
    private Stack stack;

    public static DataTreeCursor create(IData d) {
        return new DataTreeCursor(d.getCursor());
    }

    public static DataTreeCursor create(IDataCursor c) {
        return new DataTreeCursor(c);
    }

    private DataTreeCursor(IDataCursor cursor) {
        this.cursor = cursor;
        this.stack = new Stack();
    }

    public void setErrorMode(int m) {
        this.cursor.setErrorMode(m);
    }

    public DataException getLastError() {
        return this.cursor.getLastError();
    }

    public boolean hasMoreErrors() {
        return this.cursor.hasMoreErrors();
    }

    public void home() {
        this.cursor.home();
    }

    public String getKey() {
        return this.cursor.getKey();
    }

    public Object getValue() {
        return this.cursor.getValue();
    }

    public void setKey(String key) {
        this.cursor.setKey(key);
    }

    public void setValue(Object value) {
        this.cursor.setValue(value);
    }

    public boolean delete() {
        return this.cursor.delete();
    }

    public void insertBefore(String key, Object value) {
        this.cursor.insertBefore(key, value);
    }

    public void insertAfter(String key, Object value) {
        this.cursor.insertAfter(key, value);
    }

    public IData insertDataBefore(String key) {
        return this.cursor.insertDataBefore(key);
    }

    public IData insertDataAfter(String key) {
        return this.cursor.insertDataAfter(key);
    }

    public boolean next() {
        return this.cursor.next();
    }

    public boolean next(String key) {
        return this.cursor.next(key);
    }

    public boolean previous() {
        return this.cursor.previous();
    }

    public boolean previous(String key) {
        return this.cursor.previous(key);
    }

    public boolean first() {
        return this.cursor.first();
    }

    public boolean first(String key) {
        return this.cursor.first(key);
    }

    public boolean last() {
        return this.cursor.last();
    }

    public boolean last(String key) {
        return this.cursor.last(key);
    }

    public boolean hasMoreData() {
        return this.cursor.hasMoreData();
    }

    public IDataCursor getCursorClone() {
        DataTreeCursor tc = new DataTreeCursor(this.cursor.getCursorClone());
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            tc.stack.addElement(((IDataCursor)e.nextElement()).getCursorClone());
        }
        return tc;
    }

    public boolean up() {
        if (!this.stack.empty()) {
            this.cursor.destroy();
            this.cursor = (IDataCursor)this.stack.pop();
            return true;
        }
        return false;
    }

    public boolean down() {
        Object v = this.getValue();
        if (v instanceof IData) {
            this.stack.push(this.cursor);
            this.cursor = new DataTreeCursor(((IData)v).getCursor());
            return true;
        }
        return false;
    }

    public String getPath() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            sb.append("/");
            sb.append(this.getPathElement((IDataCursor)e.nextElement()));
        }
        sb.append("/");
        sb.append(this.getPathElement(this.cursor));
        return sb.toString();
    }

    private String getPathElement(IDataCursor c) {
        IDataCursor dc = c.getCursorClone();
        String key = dc.getKey();
        int i = 1;
        while (dc.previous(key)) {
            ++i;
        }
        dc.destroy();
        if (key == null) {
            key = "";
        }
        if (i > 1) {
            return key + "[" + i + "]";
        }
        return key;
    }

    public boolean navigate(String path) {
        boolean ok = true;
        IDataCursor sc = this.cursor.getCursorClone();
        Stack<IDataCursor> ss = new Stack<IDataCursor>();
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            ss.addElement(((IDataCursor)e.nextElement()).getCursorClone());
        }
        TreePath tp = TreePath.safeCreate(path);
        if (tp == null) {
            return false;
        }
        if (tp.isAbsolute()) {
            while (this.up()) {
            }
            this.home();
        }
        Enumeration e2 = tp.getTokens();
        while (ok && e2.hasMoreElements()) {
            TreePathToken tt = (TreePathToken)e2.nextElement();
            boolean lastToken = !e2.hasMoreElements();
            switch (tt.getType()) {
                case 3: {
                    this.up();
                    this.home();
                    break;
                }
                case 2: {
                    this.down();
                    break;
                }
                case 1: {
                    int i;
                    String key = tt.getKey();
                    int idx = tt.getIndex();
                    if (idx > 0) {
                        for (i = 0; i < idx; ++i) {
                            if (i == 0 && this.first(key) || i > 0 && this.next(key)) continue;
                            ok = false;
                        }
                    } else {
                        if (idx >= 0) break;
                        for (i = 0; i > idx; --i) {
                            if (i == 0 && this.last(key) || i < 0 && this.previous(key)) continue;
                            ok = false;
                        }
                    }
                    break;
                }
            }
            if (!this.hasMoreErrors()) continue;
            ok = false;
        }
        if (ok) {
            sc.destroy();
            e2 = ss.elements();
            while (e2.hasMoreElements()) {
                ((IDataCursor)e2.nextElement()).destroy();
            }
        } else {
            this.destroy();
            this.cursor = sc;
            this.stack = ss;
        }
        return ok;
    }

    public void destroy() {
        while (this.up()) {
        }
        this.cursor.destroy();
    }

    public String toString() {
        return this.cursor.toString();
    }
}

