/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.DataException;
import com.wm.data.IData;
import com.wm.data.IDataSharedCursor;
import com.wm.data.TreePath;
import com.wm.data.TreePathToken;
import com.wm.txn.ITransaction;
import com.wm.txn.TransactionException;
import java.util.Enumeration;
import java.util.Stack;

public class DataSharedTreeCursor
implements IDataSharedCursor {
    private static String BUNDLE = "com.wm.resources.CoreExcpMsgs";
    private static String MSG0025 = "BAC.0003.0025";
    private IDataSharedCursor cursor;
    private Stack stack;
    private ITransaction txn;

    public static DataSharedTreeCursor create(IData d) {
        return new DataSharedTreeCursor(d.getSharedCursor());
    }

    public static DataSharedTreeCursor create(IDataSharedCursor c) {
        return new DataSharedTreeCursor(c);
    }

    private DataSharedTreeCursor(IDataSharedCursor cursor) {
        this.cursor = cursor;
        this.stack = new Stack();
    }

    public void home() throws DataException {
        this.cursor.home();
    }

    public boolean up() {
        if (!this.stack.empty()) {
            this.cursor.destroy();
            this.cursor = (IDataSharedCursor)this.stack.pop();
            return true;
        }
        return false;
    }

    public boolean down() throws DataException {
        Object v = this.getValue();
        if (v instanceof IData) {
            this.stack.push(this.cursor);
            IDataSharedCursor dsc = ((IData)v).getSharedCursor();
            if (this.txn != null) {
                try {
                    this.txn.joinTXN(dsc);
                }
                catch (TransactionException ex) {
                    dsc.destroy();
                    throw new DataException(ex);
                }
            }
            this.cursor = new DataSharedTreeCursor(dsc);
            return true;
        }
        return false;
    }

    public String getPath() throws DataException {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            sb.append("/");
            sb.append(this.getPathElement((IDataSharedCursor)e.nextElement()));
        }
        sb.append("/");
        sb.append(this.getPathElement(this.cursor));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPathElement(IDataSharedCursor c) throws DataException {
        IDataSharedCursor dc = c.getCursorClone();
        try {
            String key = dc.getKey();
            int i = 1;
            while (dc.previous(key)) {
                ++i;
            }
            if (key == null) {
                key = "";
            }
            if (i > 1) {
                String string = key + "[" + i + "]";
                return string;
            }
            String string = key;
            return string;
        }
        catch (DataException e) {
            String string = "";
            return string;
        }
        finally {
            dc.destroy();
        }
    }

    public boolean navigate(String path) throws DataException {
        DataException err = null;
        boolean ok = true;
        IDataSharedCursor sc = this.cursor.getCursorClone();
        Stack<IDataSharedCursor> ss = new Stack<IDataSharedCursor>();
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            ss.addElement(((IDataSharedCursor)e.nextElement()).getCursorClone());
        }
        try {
            TreePath tp = TreePath.safeCreate(path);
            if (tp == null) {
                return false;
            }
            if (tp.isAbsolute()) {
                while (this.up()) {
                }
                this.home();
            }
            Enumeration e2 = tp.getTokens();
            block9: while (ok && e2.hasMoreElements()) {
                TreePathToken tt = (TreePathToken)e2.nextElement();
                boolean lastToken = !e2.hasMoreElements();
                switch (tt.getType()) {
                    case 3: {
                        this.up();
                        this.home();
                        break;
                    }
                    case 2: {
                        this.down();
                        break;
                    }
                    case 1: {
                        int i;
                        String key = tt.getKey();
                        int idx = tt.getIndex();
                        if (idx > 0) {
                            for (i = 0; i < idx; ++i) {
                                if (i == 0 && this.first(key) || i > 0 && this.next(key)) continue;
                                ok = false;
                            }
                            continue block9;
                        }
                        if (idx >= 0) break;
                        for (i = 0; i > idx; --i) {
                            if (i == 0 && this.last(key) || i < 0 && this.previous(key)) continue;
                            ok = false;
                        }
                        continue block9;
                    }
                }
            }
        }
        catch (DataException e2) {
            ok = false;
            err = e2;
        }
        if (ok) {
            sc.destroy();
            e = ss.elements();
            while (e.hasMoreElements()) {
                ((IDataSharedCursor)e.nextElement()).destroy();
            }
        } else {
            this.destroy();
            this.cursor = sc;
            this.stack = ss;
        }
        if (err != null) {
            throw err;
        }
        return ok;
    }

    public String getKey() throws DataException {
        return this.cursor.getKey();
    }

    public Object getValue() throws DataException {
        return this.cursor.getValue();
    }

    public Object getValueReference() throws DataException {
        return this.cursor.getValueReference();
    }

    public void setKey(String key) throws DataException {
        this.cursor.setKey(key);
    }

    public void setValue(Object value) throws DataException {
        this.cursor.setValue(value);
    }

    public boolean delete() throws DataException {
        return this.cursor.delete();
    }

    public void insertBefore(String key, Object value) throws DataException {
        this.cursor.insertBefore(key, value);
    }

    public void insertAfter(String key, Object value) throws DataException {
        this.cursor.insertAfter(key, value);
    }

    public IData insertDataBefore(String key) throws DataException {
        return this.cursor.insertDataBefore(key);
    }

    public IData insertDataAfter(String key) throws DataException {
        return this.cursor.insertDataAfter(key);
    }

    public boolean next() throws DataException {
        return this.cursor.next();
    }

    public boolean previous() throws DataException {
        return this.cursor.previous();
    }

    public boolean first() throws DataException {
        return this.cursor.first();
    }

    public boolean last() throws DataException {
        return this.cursor.last();
    }

    public boolean next(String key) throws DataException {
        return this.cursor.next(key);
    }

    public boolean previous(String key) throws DataException {
        return this.cursor.previous(key);
    }

    public boolean first(String key) throws DataException {
        return this.cursor.first(key);
    }

    public boolean last(String key) throws DataException {
        return this.cursor.last(key);
    }

    public boolean hasMoreData() throws DataException {
        return this.cursor.hasMoreData();
    }

    public IDataSharedCursor getCursorClone() throws DataException {
        DataSharedTreeCursor tc = new DataSharedTreeCursor(this.cursor.getCursorClone());
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            tc.stack.addElement(((IDataSharedCursor)e.nextElement()).getCursorClone());
        }
        return tc;
    }

    public void destroy() {
        while (this.up()) {
        }
        this.cursor.destroy();
    }

    public boolean isTXNSupported() {
        return this.cursor.isTXNSupported();
    }

    public ITransaction startTXN() throws TransactionException {
        if (this.txn != null) {
            throw new TransactionException(MSG0025, BUNDLE);
        }
        this.txn = this.cursor.startTXN();
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            this.txn.joinTXN((IDataSharedCursor)((Object)e));
        }
        return this.txn;
    }

    public void txnJoin(ITransaction txn) throws TransactionException {
        if (this.txn != null) {
            throw new TransactionException(MSG0025, BUNDLE);
        }
        this.txn = txn;
    }

    public void txnAborted() {
        this.txn = null;
    }

    public void txnCommitted() {
        this.txn = null;
    }
}

