/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.DataException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataSharedCursor;
import com.wm.txn.ITransaction;
import com.wm.txn.TransactionException;

public final class DataSharedCursorEmulator
implements IDataSharedCursor {
    private static String BUNDLE = "com.wm.resources.CoreExcpMsgs";
    private static String MSG0029 = "BAC.0003.0029";
    private IDataCursor dc;

    public static DataSharedCursorEmulator create(IDataCursor c) {
        return new DataSharedCursorEmulator(c);
    }

    private DataSharedCursorEmulator(IDataCursor dc) {
        this.dc = dc;
    }

    public void home() throws DataException {
        this.dc.home();
        this.errorCheck();
    }

    public String getKey() throws DataException {
        return this.errorCheck(this.dc.getKey());
    }

    public Object getValue() throws DataException {
        return this.errorCheck(this.dc.getValue());
    }

    public Object getValueReference() throws DataException {
        return this.errorCheck(this.dc.getValue());
    }

    public void setKey(String key) throws DataException {
        this.dc.setKey(key);
        this.errorCheck();
    }

    public void setValue(Object value) throws DataException {
        this.dc.setValue(value);
        this.errorCheck();
    }

    public boolean delete() throws DataException {
        return this.errorCheck(this.dc.delete());
    }

    public void insertBefore(String key, Object value) throws DataException {
        this.dc.insertBefore(key, value);
        this.errorCheck();
    }

    public void insertAfter(String key, Object value) throws DataException {
        this.dc.insertAfter(key, value);
        this.errorCheck();
    }

    public IData insertDataBefore(String key) throws DataException {
        return this.errorCheck(this.dc.insertDataBefore(key));
    }

    public IData insertDataAfter(String key) throws DataException {
        return this.errorCheck(this.dc.insertDataAfter(key));
    }

    public boolean next() throws DataException {
        return this.errorCheck(this.dc.next());
    }

    public boolean previous() throws DataException {
        return this.errorCheck(this.dc.previous());
    }

    public boolean first() throws DataException {
        return this.errorCheck(this.dc.first());
    }

    public boolean last() throws DataException {
        return this.errorCheck(this.dc.last());
    }

    public boolean hasMoreData() throws DataException {
        return this.errorCheck(this.dc.hasMoreData());
    }

    public void destroy() {
        if (this.dc != null) {
            this.dc.destroy();
        }
        this.dc = null;
    }

    public IDataSharedCursor getCursorClone() throws DataException {
        return this.errorCheck(new DataSharedCursorEmulator(this.dc.getCursorClone()));
    }

    public boolean first(String key) throws DataException {
        return this.errorCheck(this.dc.first(key));
    }

    public boolean last(String key) throws DataException {
        return this.errorCheck(this.dc.last(key));
    }

    public boolean next(String key) throws DataException {
        return this.errorCheck(this.dc.next(key));
    }

    public boolean previous(String key) throws DataException {
        return this.errorCheck(this.dc.previous(key));
    }

    public boolean isTXNSupported() {
        return false;
    }

    public ITransaction startTXN() throws TransactionException {
        throw new TransactionException(MSG0029, BUNDLE);
    }

    public void txnJoin(ITransaction txn) throws TransactionException {
        throw new TransactionException(MSG0029, BUNDLE);
    }

    public void txnAborted() {
    }

    public void txnCommitted() {
    }

    private boolean keyMatch(IDataCursor cc, String key) {
        String k = cc.getKey();
        return key == null && k == null || key != null && k != null && key.equals(k);
    }

    private boolean errorCheck(boolean ret) throws DataException {
        if (this.dc.hasMoreErrors()) {
            throw this.dc.getLastError();
        }
        return ret;
    }

    private IDataSharedCursor errorCheck(IDataSharedCursor ret) throws DataException {
        if (this.dc.hasMoreErrors()) {
            throw this.dc.getLastError();
        }
        return ret;
    }

    private IData errorCheck(IData ret) throws DataException {
        if (this.dc.hasMoreErrors()) {
            throw this.dc.getLastError();
        }
        return ret;
    }

    private String errorCheck(String ret) throws DataException {
        if (this.dc.hasMoreErrors()) {
            throw this.dc.getLastError();
        }
        return ret;
    }

    private Object errorCheck(Object ret) throws DataException {
        if (this.dc.hasMoreErrors()) {
            throw this.dc.getLastError();
        }
        return ret;
    }

    private void errorCheck() throws DataException {
        if (this.dc.hasMoreErrors()) {
            throw this.dc.getLastError();
        }
    }
}

