/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.BasicData;
import com.wm.data.DataException;
import java.io.Serializable;

final class DataElement
implements Serializable {
    static final long serialVersionUID = 8558134258174382699L;
    static final int version = 1;
    DataElement prev;
    DataElement next;
    BasicData ivalue;
    String key;
    Object value;

    DataElement(BasicData ivalue, String key, Object value) {
        this.ivalue = ivalue;
        this.setKey(key);
        this.setValue(value);
    }

    public void setErrorMode(int m) {
    }

    public DataException getLastError() {
        return null;
    }

    public boolean hasMoreErrors() {
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean delete() {
        --this.ivalue.size;
        if (this.prev == null) {
            this.ivalue.first = this.next;
        } else {
            this.prev.next = this.next;
        }
        if (this.next == null) {
            this.ivalue.last = this.prev;
        } else {
            this.next.prev = this.prev;
        }
        this.prev = null;
        this.ivalue = null;
        return true;
    }

    public DataElement insertBefore(String key, Object value) {
        DataElement item = new DataElement(this.ivalue, key, value);
        item.insert(this.prev);
        return item;
    }

    public DataElement insertAfter(String key, Object value) {
        DataElement item = new DataElement(this.ivalue, key, value);
        item.insert(this);
        return item;
    }

    public DataElement next(String key) {
        DataElement walk = this.next;
        while (walk != null) {
            if (walk.key == key || walk.key.equals(key)) {
                return walk;
            }
            walk = walk.next;
        }
        return null;
    }

    void insert(DataElement afterThis) {
        if (afterThis == null) {
            this.next = this.ivalue.first;
            this.prev = null;
            this.ivalue.first = this;
        } else {
            this.next = afterThis.next;
            this.prev = afterThis;
            afterThis.next = this;
        }
        if (this.next != null) {
            this.next.prev = this;
        } else {
            this.ivalue.last = this;
        }
        ++this.ivalue.size;
    }

    void addToEnd() {
        if (this.ivalue.size == 0) {
            this.ivalue.first = this;
            this.ivalue.last = this;
            this.next = null;
            this.prev = null;
        } else {
            this.prev = this.ivalue.last;
            this.next = null;
            this.ivalue.last.next = this;
            this.ivalue.last = this;
        }
        ++this.ivalue.size;
    }

    void addToFront() {
        if (this.ivalue.size == 0) {
            this.ivalue.first = this;
            this.ivalue.last = this;
            this.next = null;
            this.prev = null;
        } else {
            this.prev = null;
            this.next = this.ivalue.first;
            this.ivalue.first.prev = this;
            this.ivalue.first = this;
        }
        ++this.ivalue.size;
    }
}

