/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.DataException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataSharedCursor;
import java.util.Stack;

public final class DataCursorEmulator
implements IDataCursor {
    private IDataSharedCursor cursor;
    private Stack errors;
    private int errMode;

    public static DataCursorEmulator create(IDataSharedCursor c) {
        return new DataCursorEmulator(c);
    }

    private DataCursorEmulator(IDataSharedCursor cursor) {
        this.cursor = cursor;
        this.errors = new Stack();
        this.errMode = 1;
    }

    public IDataSharedCursor getCursor() {
        return this.cursor;
    }

    public void setCursor(IDataSharedCursor cursor) {
        this.cursor = cursor;
    }

    private void pushError(DataException e) {
        if (this.errMode == 1) {
            while (!this.errors.empty()) {
                this.errors.pop();
            }
        }
        this.errors.push(e);
    }

    public void setErrorMode(int m) {
        this.errMode = m;
    }

    public DataException getLastError() {
        if (!this.errors.empty()) {
            return (DataException)this.errors.pop();
        }
        return null;
    }

    public boolean hasMoreErrors() {
        return !this.errors.empty();
    }

    public void home() {
        try {
            this.cursor.home();
        }
        catch (DataException e) {
            this.pushError(e);
        }
    }

    public String getKey() {
        try {
            return this.cursor.getKey();
        }
        catch (DataException e) {
            this.pushError(e);
            return null;
        }
    }

    public Object getValue() {
        try {
            return this.cursor.getValue();
        }
        catch (DataException e) {
            this.pushError(e);
            return null;
        }
    }

    public void setKey(String key) {
        try {
            this.cursor.setKey(key);
        }
        catch (DataException e) {
            this.pushError(e);
        }
    }

    public void setValue(Object value) {
        try {
            this.cursor.setValue(value);
        }
        catch (DataException e) {
            this.pushError(e);
        }
    }

    public boolean delete() {
        try {
            return this.cursor.delete();
        }
        catch (DataException e) {
            this.pushError(e);
            return this.next();
        }
    }

    public void insertBefore(String key, Object value) {
        try {
            this.cursor.insertBefore(key, value);
        }
        catch (DataException e) {
            this.pushError(e);
        }
    }

    public void insertAfter(String key, Object value) {
        try {
            this.cursor.insertAfter(key, value);
        }
        catch (DataException e) {
            this.pushError(e);
        }
    }

    public IData insertDataBefore(String key) {
        try {
            return this.cursor.insertDataBefore(key);
        }
        catch (DataException e) {
            this.pushError(e);
            return null;
        }
    }

    public IData insertDataAfter(String key) {
        try {
            return this.cursor.insertDataAfter(key);
        }
        catch (DataException e) {
            this.pushError(e);
            return null;
        }
    }

    public boolean next() {
        try {
            return this.cursor.next();
        }
        catch (DataException e) {
            this.pushError(e);
            return false;
        }
    }

    public boolean next(String key) {
        try {
            return this.cursor.next(key);
        }
        catch (DataException e) {
            this.pushError(e);
            return false;
        }
    }

    public boolean previous() {
        try {
            return this.cursor.previous();
        }
        catch (DataException e) {
            this.pushError(e);
            return false;
        }
    }

    public boolean previous(String key) {
        try {
            return this.cursor.previous(key);
        }
        catch (DataException e) {
            this.pushError(e);
            return false;
        }
    }

    public boolean first() {
        try {
            return this.cursor.first();
        }
        catch (DataException e) {
            this.pushError(e);
            return false;
        }
    }

    public boolean first(String key) {
        try {
            return this.cursor.first(key);
        }
        catch (DataException e) {
            this.pushError(e);
            return false;
        }
    }

    public boolean last() {
        try {
            return this.cursor.last();
        }
        catch (DataException e) {
            this.pushError(e);
            return false;
        }
    }

    public boolean last(String key) {
        try {
            return this.cursor.last(key);
        }
        catch (DataException e) {
            this.pushError(e);
            return false;
        }
    }

    public boolean hasMoreData() {
        try {
            return this.cursor.hasMoreData();
        }
        catch (DataException e) {
            this.pushError(e);
            return false;
        }
    }

    public void destroy() {
        this.cursor.destroy();
    }

    public IDataCursor getCursorClone() {
        try {
            return new DataCursorEmulator(this.cursor.getCursorClone());
        }
        catch (DataException e) {
            this.pushError(e);
            return null;
        }
    }

    public String toString() {
        return this.cursor.toString();
    }
}

