/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.BasicData;
import com.wm.data.DataElement;
import com.wm.data.DataException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.resources.BasicDataBundle;
import com.wm.util.List;
import java.util.ResourceBundle;

class DataCursor
implements IDataCursor {
    DataElement now;
    BasicData data;

    DataCursor(DataElement now, BasicData data) {
        this.init(now, data);
    }

    void init(DataElement now, BasicData data) {
        this.now = now;
        this.data = data;
    }

    public void home() {
        this.now = null;
    }

    public void setErrorMode(int m) {
    }

    public DataException getLastError() {
        return null;
    }

    public boolean hasMoreErrors() {
        return false;
    }

    public String getKey() {
        if (this.now == null) {
            return null;
        }
        return this.now.key;
    }

    public Object getValue() {
        if (this.now == null) {
            return null;
        }
        return this.now.value;
    }

    public void setKey(String key) {
        if (this.now != null) {
            this.now.setKey(key);
        }
    }

    public void setValue(Object value) {
        if (this.now != null) {
            this.now.value = value;
        }
    }

    public boolean delete() {
        if (this.now == null) {
            return false;
        }
        DataElement hold = this.now;
        boolean more = hold.next != null;
        this.now = more ? hold.next : hold.prev;
        hold.delete();
        return more;
    }

    public void insertBefore(String key, Object value) {
        if (this.now != null) {
            this.now = this.now.insertBefore(key, value);
        } else {
            this.now = new DataElement(this.data, key, value);
            this.now.addToFront();
        }
    }

    public void insertAfter(String key, Object value) {
        if (this.now != null) {
            this.now = this.now.insertAfter(key, value);
        } else {
            this.now = new DataElement(this.data, key, value);
            this.now.addToEnd();
        }
    }

    public IData insertDataBefore(String key) {
        IData nd = BasicData.create();
        this.insertBefore(key, nd);
        return nd;
    }

    public IData insertDataAfter(String key) {
        IData nd = BasicData.create();
        this.insertAfter(key, nd);
        return nd;
    }

    public boolean next() {
        if (this.now == null) {
            this.now = this.data.first;
        } else {
            if (this.now.next == null) {
                return false;
            }
            this.now = this.now.next;
        }
        return this.now != null;
    }

    public boolean next(String key) {
        if (this.now == null) {
            return this._next(this.data.first, key);
        }
        return this._next(this.now.next, key);
    }

    private boolean _next(DataElement walk, String key) {
        while (walk != null) {
            if ((key == null || walk.key == null) && key != walk.key) {
                return false;
            }
            if (walk.key == key || walk.key.equals(key)) {
                this.now = walk;
                return true;
            }
            walk = walk.next;
        }
        return false;
    }

    public boolean previous() {
        if (this.now == null) {
            this.now = this.data.last;
        } else {
            if (this.now.prev == null) {
                return false;
            }
            this.now = this.now.prev;
        }
        return this.now != null;
    }

    public boolean previous(String key) {
        if (this.now == null) {
            return this._previous(this.data.last, key);
        }
        return this._previous(this.now.prev, key);
    }

    private boolean _previous(DataElement walk, String key) {
        while (walk != null) {
            if ((key == null || walk.key == null) && key != walk.key) {
                return false;
            }
            if (walk.key == key || walk.key.equals(key)) {
                this.now = walk;
                return true;
            }
            walk = walk.prev;
        }
        return false;
    }

    public boolean first() {
        this.now = this.data.first;
        return this.now != null;
    }

    public boolean first(String key) {
        return this._next(this.data.first, key);
    }

    public boolean last() {
        this.now = this.data.last;
        return this.now != null;
    }

    public boolean last(String key) {
        return this._previous(this.data.last, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        BasicData basicData = this.data;
        synchronized (basicData) {
            if (this.data.oldCursors == null) {
                this.data.oldCursors = new List();
            } else if (this.data.oldCursors.contains(this)) {
                return;
            }
            this.now = null;
            this.data.oldCursors.addElement(this);
        }
    }

    public boolean hasMoreData() {
        if (this.now == null) {
            return this.data.first != null;
        }
        return this.now.next != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IDataCursor getCursorClone() {
        DataCursor clone = null;
        BasicData basicData = this.data;
        synchronized (basicData) {
            if (this.data.oldCursors != null && this.data.oldCursors.size() > 0) {
                clone = (DataCursor)this.data.oldCursors.removeLastElement();
            }
        }
        if (clone == null) {
            clone = new DataCursor(this.now, this.data);
        } else {
            clone.init(this.now, this.data);
        }
        return clone;
    }

    public String toString() {
        ResourceBundle bundle = BasicData.bundle;
        if (this.now == null) {
            return bundle.getString(BasicDataBundle.IDATACURSOR_NULL);
        }
        return bundle.getString(BasicDataBundle.IDATACURSOR) + ":" + this.now.key;
    }
}

