/*
 * Decompiled with CFR 0.152.
 */
package com.wm.data;

import com.wm.data.DataCursor;
import com.wm.data.DataElement;
import com.wm.data.DataSharedCursorEmulator;
import com.wm.data.HashCursor;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataPortable;
import com.wm.data.IDataSharedCursor;
import com.wm.data.IDataTreeCursor;
import com.wm.data.IndexCursor;
import com.wm.data.OldDataCursor;
import com.wm.data.TreeCursor;
import com.wm.data.resources.BasicDataBundle;
import com.wm.util.List;
import com.wm.util.coder.IDataCodable;
import java.io.Serializable;
import java.util.ResourceBundle;

public class BasicData
implements IData,
Serializable {
    static ResourceBundle bundle = ResourceBundle.getBundle("com.wm.data.resources.BasicDataBundle");
    static final long serialVersionUID = 932528005360284573L;
    final int version = 1;
    DataElement first;
    DataElement last;
    int size;
    transient List oldCursors = new List();
    transient List oldHashCursors = new List();
    private transient boolean recurse_flag = false;

    public IDataCursor getCursor() {
        return this.getOldCursor(null);
    }

    private IDataCursor getNewCursor() {
        return this.getCursor(null);
    }

    private IDataCursor getOldCursor() {
        return this.getOldCursor(null);
    }

    public IDataHashCursor getHashCursor() {
        return HashCursor.create(this.getOldCursor());
    }

    public IDataIndexCursor getIndexCursor() {
        return IndexCursor.create(this.getCursor());
    }

    public IDataTreeCursor getTreeCursor() {
        return TreeCursor.create(this.getCursor());
    }

    public IDataSharedCursor getSharedCursor() {
        return DataSharedCursorEmulator.create(this.getNewCursor());
    }

    private synchronized DataCursor getCursor(DataElement item) {
        DataCursor ret = null;
        if (this.oldCursors != null && this.oldCursors.size() > 0) {
            ret = (DataCursor)this.oldCursors.removeLastElement();
        }
        if (ret == null) {
            ret = new DataCursor(item, this);
        }
        ret.init(item, this);
        return ret;
    }

    private synchronized OldDataCursor getOldCursor(DataElement item) {
        OldDataCursor ret = null;
        if (this.oldHashCursors != null && this.oldHashCursors.size() > 0) {
            ret = (OldDataCursor)this.oldHashCursors.removeLastElement();
        }
        if (ret == null) {
            ret = new OldDataCursor(item, this);
        }
        ret.init(item, this);
        return ret;
    }

    public static IData create() {
        return new BasicData();
    }

    public IData copy() {
        BasicData copy = new BasicData();
        DataElement e = this.first;
        while (e != null) {
            DataElement e1 = new DataElement(copy, e.key, e.value);
            e1.addToEnd();
            e = e.next;
        }
        return copy;
    }

    public String toString() {
        if (this.recurse_flag) {
            String recursedMsg = bundle.getString(BasicDataBundle.BASIC_DATA_OBJECT_RECURSED);
            return " >>> " + recursedMsg + " <<< ";
        }
        this.recurse_flag = true;
        DataElement de = this.first;
        StringBuffer sb = new StringBuffer();
        sb.append(">>>");
        String labelMsg = bundle.getString(BasicDataBundle.BASIC_DATA_TO_STRING_LABEL);
        sb.append(labelMsg);
        sb.append(":");
        while (de != null) {
            sb.append(de.key);
            sb.append("=");
            Object val = de.value;
            if (val instanceof Object[]) {
                Object[] v = (Object[])val;
                StringBuffer ab = new StringBuffer();
                for (int j = 0; j < v.length; ++j) {
                    ab.append("[" + j + "]" + this.idataObject(v[j]) + (j < v.length - 1 ? "," : ""));
                }
                val = ab.toString();
            }
            sb.append(this.idataObject(val));
            de = de.next;
            if (de == null) break;
            sb.append(",");
        }
        sb.append("<<<");
        this.recurse_flag = false;
        return sb.toString();
    }

    private Object idataObject(Object value) {
        if (!(value instanceof IData)) {
            if (value instanceof IDataCodable) {
                value = ((IDataCodable)value).getIData();
            } else if (value instanceof IDataPortable) {
                value = ((IDataPortable)value).getAsData();
            }
        }
        return value;
    }
}

