/*
 * Decompiled with CFR 0.152.
 */
package com.wm.cert;

import com.wm.cert.Name;
import com.wm.cert.X509CertIf;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.util.Hashtable;

public final class CertManager {
    private static Class gProviderCertClass;
    static final String DEF_PROVIDER = "com.wm.ext.iaik.IAIKCert";
    static Hashtable gTrustedCAs;

    public static void init() {
        String providerName = Config.getProperty("watt.security.certProvider");
        String string = providerName = providerName == null ? "" : providerName.trim();
        if (!CertManager.setProvider(providerName)) {
            CertManager.setProvider(DEF_PROVIDER);
        }
        CertManager.loadTrustedCAs();
    }

    static boolean setProvider(String className) {
        if (className == null || className.length() == 0) {
            return false;
        }
        try {
            gProviderCertClass = Class.forName(className);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static X509CertIf newInstance() {
        try {
            return (X509CertIf)gProviderCertClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static X509CertIf[] newInstanceArray(int len) {
        try {
            X509CertIf[] arr = (X509CertIf[])Array.newInstance(gProviderCertClass, len);
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = CertManager.newInstance();
            }
            return arr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static X509CertIf[] newInstanceArray(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        X509CertIf[] chain = new X509CertIf[arr.length];
        for (int i = 0; i < chain.length; ++i) {
            chain[i] = CertManager.newInstance();
            chain[i].setCertificate(arr[i]);
        }
        return chain;
    }

    static void loadTrustedCAs() {
        gTrustedCAs = new Hashtable();
        String certDir = Config.getProperty("watt.security.CADir");
        String string = certDir = certDir == null ? "" : certDir.trim();
        if (certDir.length() == 0) {
            return;
        }
        File dir = new File(certDir);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        String[] fileList = dir.list();
        if (fileList == null || fileList.length == 0) {
            return;
        }
        String path = certDir + File.separator;
        for (int i = 0; i < fileList.length; ++i) {
            try {
                FileInputStream fis = new FileInputStream(path + fileList[i]);
                X509CertIf cert = CertManager.newInstance();
                cert.initialize(fis);
                Name caName = (Name)cert.getSubjectDN();
                gTrustedCAs.put(((Object)caName).toString().trim(), cert);
                continue;
            }
            catch (Exception e) {
                JournalLogger.logDebugPlus(2, 3, 9, fileList[i], e.getMessage());
            }
        }
    }

    public static boolean isTrustedChain(X509CertIf[] chain) {
        if (chain != null) {
            for (int i = 0; i < chain.length; ++i) {
                X509CertIf caCert;
                String subjectName;
                Name subject = (Name)chain[i].getIssuerDN();
                if (subject == null || (subjectName = ((Object)subject).toString().trim()) == null || !gTrustedCAs.containsKey(subjectName) || !chain[i].verify((caCert = (X509CertIf)gTrustedCAs.get(subjectName)).getPublicKey())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        CertManager.init();
    }
}

