/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class UnicodeValueCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final byte ascii0 = 48;
    private static final byte asciia = 97;
    private static final byte asciib = 92;
    private static final byte asciiu = 117;
    private static final byte[] escesc = new byte[]{92, 117, 92, 117};
    private static final byte[] hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final String DEFAULT = new String();
    private static final int WIRE_SIZE = 4;

    public int getBrokerType() {
        return 66;
    }

    public int getCoderType() {
        return 1;
    }

    public UnicodeValueCoder() {
        super(DEFAULT, 4);
    }

    public void encode(BytePoolWriter writer, Object data) {
        String str = data.toString();
        int strlen = str.length();
        char[] ch = new char[strlen];
        byte[] b = new byte[ch.length * 2];
        str.getChars(0, strlen, ch, 0);
        int byteOffset = 0;
        for (int charOffset = 0; charOffset < ch.length; ++charOffset) {
            b[byteOffset++] = (byte)(ch[charOffset] >> 8 & 0xFF);
            b[byteOffset++] = (byte)(ch[charOffset] & 0xFF);
        }
        writer.startStringValue();
        writer.write(b);
        writer.endStringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(BytePoolReader reader) {
        int len = reader.readInt() - 4;
        byte[] b = new byte[len];
        StringBuffer buffer = new StringBuffer(len / 2);
        reader.read(b);
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            int j = 0;
            while (j < len) {
                buffer.append((char)(b[j++] << 8 | b[j++] & 0xFF));
            }
        }
        int transitPosition = len % 4;
        if (transitPosition != 0) {
            if (this._verbose) {
                UnicodeValueCoder.log("Adjusting transit position by skipping " + (4 - transitPosition) + " byte(s)");
            }
            reader.skip(4 - transitPosition);
            if (this._verbose) {
                UnicodeValueCoder.log("@ position (" + reader.getPosition() + ")");
            }
        }
        return buffer.toString();
    }

    public String getJavaClassName() {
        return String.class.getName();
    }
}

