/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class StringValueCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final byte ascii0 = 48;
    private static final byte asciia = 97;
    private static final byte asciib = 92;
    private static final byte asciiu = 117;
    private static final byte[] escesc = new byte[]{92, 117, 92, 117};
    private static final byte[] hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final String DEFAULT = new String();
    private static final int WIRE_SIZE = -1;
    private boolean forNames;

    public int getBrokerType() {
        return 65;
    }

    public int getCoderType() {
        return 1;
    }

    public StringValueCoder() {
        this(false);
    }

    public StringValueCoder(boolean forNames) {
        super(DEFAULT, -1);
        this.forNames = forNames;
    }

    public void encode(BytePoolWriter writer, Object data) {
        int i;
        String str = data.toString();
        int strlen = str.length();
        char[] ch = new char[strlen];
        str.getChars(0, strlen, ch, 0);
        boolean isExtended = false;
        for (i = 0; i < strlen; ++i) {
            if (ch[i] >= '\u0000' && ch[i] <= '\u00ff') continue;
            isExtended = true;
            break;
        }
        if (this.forNames) {
            writer.startTag();
        } else {
            writer.startField();
        }
        if (!isExtended) {
            byte[] b = new byte[strlen];
            for (int i2 = 0; i2 < b.length; ++i2) {
                b[i2] = (byte)ch[i2];
            }
            writer.write(b);
        } else {
            for (i = 0; i < strlen; ++i) {
                if (ch[i] >= '\u0000' && ch[i] < '\u00ff') {
                    if (ch[i] == '\\' && i < strlen - 1 && ch[i + 1] == 'u') {
                        writer.write(escesc);
                        ++i;
                        continue;
                    }
                    writer.writeByte(ch[i] & 0xFF);
                    continue;
                }
                writer.writeByte(92);
                writer.writeByte(117);
                writer.writeByte(this.hexChar(ch[i] >> 12 & 0xF));
                writer.writeByte(this.hexChar(ch[i] >> 8 & 0xF));
                writer.writeByte(this.hexChar(ch[i] >> 4 & 0xF));
                writer.writeByte(this.hexChar(ch[i] >> 0 & 0xF));
            }
        }
        if (this.forNames) {
            writer.endTag();
        } else {
            writer.endField();
        }
    }

    public Object decode(BytePoolReader reader) {
        String str;
        int len;
        if (this._verbose) {
            StringValueCoder.log("decode ( position=" + reader.getPosition() + ")");
        }
        int n = len = this.forNames ? reader.readShort() : reader.readInt() - 4;
        if (this._verbose) {
            StringValueCoder.log("decode ( length=" + len + ")");
        }
        int pos = 0;
        byte[] b = new byte[len];
        char[] ch = new char[len];
        reader.read(b);
        if (this._verbose) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < b.length; ++i) {
                buf.append(Integer.toHexString(b[i] & 0xFF));
                buf.append(' ');
            }
            StringValueCoder.log("tag=" + buf.toString());
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] == 92 && i < len - 3 && b[i + 1] == 117) {
                if (b[i + 2] == 92 && b[i + 3] == 117) {
                    ch[pos++] = 92;
                    ch[pos++] = 117;
                    i += 3;
                    continue;
                }
                if (i < len - 5) {
                    ch[pos++] = (char)(this.hexCharToInt(b[i + 2]) << 12 | this.hexCharToInt(b[i + 3]) << 8 | this.hexCharToInt(b[i + 4]) << 4 | this.hexCharToInt(b[i + 5]) << 0);
                    i += 5;
                    continue;
                }
            }
            ch[pos++] = (char)b[i];
        }
        if (pos < len) {
            char[] nch = new char[pos];
            System.arraycopy(ch, 0, nch, 0, nch.length);
            str = new String(nch);
        } else {
            str = new String(ch);
        }
        if (this._verbose) {
            StringValueCoder.log("decoded tag is \"" + str + "\"");
        }
        return str;
    }

    public String getJavaClassName() {
        return String.class.getName();
    }

    private int hexChar(int val) {
        return hex[val];
    }

    private int hexCharToInt(byte b) {
        int ch = b & 0xFF;
        if (ch >= 97) {
            return ch - 97 + 10;
        }
        return ch - 48;
    }

    protected static void log(String msg) {
        System.out.println("\\TAG-coder\\ > " + msg);
    }
}

