/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class ShortCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final Short DEFAULT = new Short(0);
    private static final int WIRE_SIZE = 2;

    public ShortCoder() {
        this(DEFAULT);
    }

    protected ShortCoder(Object defaultValue) {
        super(defaultValue, 2);
    }

    public int getBrokerType() {
        return 2;
    }

    public int getCoderType() {
        return 1;
    }

    public void encode(BytePoolWriter writer, Object data) {
        writer.writeShort(((Short)data).shortValue());
    }

    public Object decode(BytePoolReader reader) {
        return new Short((short)reader.readShort());
    }

    public String getJavaClassName() {
        return Short.class.getName();
    }
}

