/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.encoding.ISO8601Coder;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class SchemaTimeCoder
extends ISO8601Coder {
    private static final String LONG_TFSTR = "HH:mm:ss.SSS";
    private static final String TFSTR = "HH:mm:ss";
    private static final String DEFAULT = SchemaTimeCoder.createDateFormatter("HH:mm:ss").format(new Date());

    public SchemaTimeCoder() {
        super(DEFAULT);
    }

    public void encode(BytePoolWriter writer, Object data, Integer timezone) {
        String time = (String)data;
        int[] timespace = new int[7];
        this.parseTimeInUTC(time, 0, timespace);
        this.encodeDateTime(writer, timespace, timezone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(BytePoolReader reader, Integer timezone) {
        String time;
        DateFormat df;
        Calendar calendar = this._decode(reader);
        if (timezone != null) {
            this.applyRawOffset(calendar, timezone);
        }
        String fmtStr = calendar.get(14) > 0 ? LONG_TFSTR : TFSTR;
        DateFormat dateFormat = df = SchemaTimeCoder.createDateFormatter(fmtStr);
        synchronized (dateFormat) {
            time = df.format(calendar.getTime());
        }
        if (timezone != null) {
            time = this.appendTimeZone(time, timezone);
        }
        return time;
    }

    protected String format(Calendar time) {
        return SchemaTimeCoder.createDateFormatter(LONG_TFSTR).format(time.getTime());
    }
}

