/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.encoding.ShortCoder;
import com.wm.util.JournalLogger;

public class SchemaShortCoder
extends ShortCoder {
    private static final String DEFAULT = "0";

    public SchemaShortCoder() {
        super(DEFAULT);
    }

    public void encode(BytePoolWriter writer, Object data) {
        short s = 0;
        try {
            s = Short.parseShort((String)data);
        }
        catch (NumberFormatException nfe) {
            JournalLogger.log(30, 76, 2, data, Integer.toString(s));
        }
        writer.writeShort(s);
    }

    public Object decode(BytePoolReader reader) {
        return Short.toString((short)reader.readShort());
    }

    public String getJavaClassName() {
        return String.class.getName();
    }
}

