/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.encoding.LongCoder;
import com.wm.util.JournalLogger;

public class SchemaLongCoder
extends LongCoder {
    private static final String DEFAULT = "0";

    public SchemaLongCoder() {
        super(DEFAULT);
    }

    public void encode(BytePoolWriter writer, Object data) {
        long lon = 0L;
        try {
            lon = Long.parseLong((String)data);
        }
        catch (NumberFormatException nfe) {
            JournalLogger.log(30, 76, 2, data, Long.toString(lon));
        }
        writer.writeLong(lon);
    }

    public Object decode(BytePoolReader reader) {
        return Long.toString(reader.readLong());
    }

    public String getJavaClassName() {
        return String.class.getName();
    }
}

