/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.encoding.IntegerCoder;
import com.wm.util.JournalLogger;

public class SchemaIntCoder
extends IntegerCoder {
    private static final String DEFAULT = "0";

    public SchemaIntCoder() {
        super(DEFAULT);
    }

    public void encode(BytePoolWriter writer, Object data) {
        int i = 0;
        try {
            i = Integer.parseInt(data.toString());
        }
        catch (NumberFormatException nfe) {
            JournalLogger.log(30, 76, 2, data, Integer.toString(i));
        }
        writer.writeInt(i);
    }

    public Object decode(BytePoolReader reader) {
        return Integer.toString(reader.readInt());
    }

    public String getJavaClassName() {
        return String.class.getName();
    }
}

