/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.encoding.FloatCoder;
import com.wm.util.JournalLogger;

public class SchemaFloatCoder
extends FloatCoder {
    private static final String DEFAULT = "0.0";

    public SchemaFloatCoder() {
        super(DEFAULT);
    }

    public void encode(BytePoolWriter writer, Object data) {
        float fl = 0.0f;
        try {
            fl = Float.parseFloat((String)data);
        }
        catch (NumberFormatException nfe) {
            JournalLogger.log(30, 76, 2, data, Float.toString(fl));
        }
        writer.writeInt(Float.floatToIntBits(fl));
    }

    public Object decode(BytePoolReader reader) {
        return Float.toString(Float.intBitsToFloat(reader.readInt()));
    }

    public String getJavaClassName() {
        return String.class.getName();
    }
}

