/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.encoding.DoubleCoder;
import com.wm.util.JournalLogger;

public class SchemaDoubleCoder
extends DoubleCoder {
    private static final String DEFAULT = "0.0";

    public SchemaDoubleCoder() {
        super(DEFAULT);
    }

    public void encode(BytePoolWriter writer, Object data) {
        double dl = 0.0;
        try {
            dl = Double.parseDouble((String)data);
        }
        catch (NumberFormatException nfe) {
            JournalLogger.log(30, 76, 2, data, Double.toString(dl));
        }
        writer.writeLong(Double.doubleToLongBits(dl));
    }

    public Object decode(BytePoolReader reader) {
        return super.decode(reader).toString();
    }

    public String getJavaClassName() {
        return String.class.getName();
    }
}

