/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.encoding.ISO8601Coder;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class SchemaDateTimeCoder
extends ISO8601Coder {
    private static final String LONG_DTFSTR = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String DTFSTR = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String DEFAULT = SchemaDateTimeCoder.createDateFormatter("yyyy-MM-dd'T'HH:mm:ss").format(new Date());

    public SchemaDateTimeCoder() {
        super(DEFAULT);
    }

    public void encode(BytePoolWriter writer, Object data, Integer timezone) {
        int[] timespace = new int[7];
        int dateOffset = this.parseDateInUTC((String)data, 0, timespace);
        this.parseTimeInUTC((String)data, dateOffset + 1, timespace);
        this.encodeDateTime(writer, timespace, timezone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(BytePoolReader reader, Integer timezone) {
        String dateTime;
        DateFormat df;
        Calendar calendar = this._decode(reader);
        if (timezone != null) {
            this.applyRawOffset(calendar, timezone);
        }
        String fmtStr = calendar.get(14) > 0 ? LONG_DTFSTR : DTFSTR;
        DateFormat dateFormat = df = SchemaDateTimeCoder.createDateFormatter(fmtStr);
        synchronized (dateFormat) {
            dateTime = df.format(calendar.getTime());
        }
        if (timezone != null) {
            dateTime = this.appendTimeZone(dateTime, timezone);
        }
        return dateTime;
    }

    protected String format(Calendar date) {
        return SchemaDateTimeCoder.createDateFormatter(LONG_DTFSTR).format(date.getTime());
    }
}

