/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.encoding.ISO8601Coder;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class SchemaDateCoder
extends ISO8601Coder {
    private static final String DFSTR = "yyyy-MM-dd";
    private static final String DEFAULT = SchemaDateCoder.createDateFormatter("yyyy-MM-dd").format(new Date());

    public SchemaDateCoder() {
        super(DEFAULT);
    }

    public void encode(BytePoolWriter writer, Object data, Integer timezone) {
        int[] timespace = new int[7];
        this.parseDateInUTC((String)data, 0, timespace);
        Calendar calendar = this.computeCalendarInUTC(timespace);
        calendar.add(14, -timezone.intValue());
        short year = (short)calendar.get(1);
        byte month = (byte)calendar.get(2);
        month = (byte)(month + 1);
        byte days = (byte)calendar.get(5);
        byte hours = (byte)calendar.get(11);
        byte minutes = (byte)calendar.get(12);
        short seconds = (byte)calendar.get(13);
        short milliSeconds = (short)calendar.get(14);
        hours = (byte)(hours & 0x1F);
        hours = (byte)(hours | 0x20);
        seconds = (short)(seconds << 10 & 0xFC00);
        seconds = (short)(seconds | milliSeconds);
        writer.writeShort(year);
        writer.writeByte(month);
        writer.writeByte(days);
        writer.writeByte(hours);
        writer.writeByte(minutes);
        writer.writeShort(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(BytePoolReader reader, Integer timezone) {
        Calendar calendar = this._decode(reader);
        if (timezone != null) {
            this.applyRawOffset(calendar, timezone);
        }
        DateFormat df = SchemaDateCoder.createDateFormatter(DFSTR);
        String date = null;
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            date = df.format(calendar.getTime());
        }
        if (timezone != null) {
            date = this.appendTimeZone(date, timezone);
        }
        return date;
    }

    protected String format(Calendar date) {
        return SchemaDateCoder.createDateFormatter(DFSTR).format(date.getTime());
    }
}

