/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.encoding.BooleanCoder;

public class SchemaBooleanCoder
extends BooleanCoder {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public SchemaBooleanCoder() {
        super(FALSE);
    }

    public void encode(BytePoolWriter writer, Object data) {
        String value = (String)data;
        writer.writeByte(value.equalsIgnoreCase(TRUE) || value.equals("1") ? 1 : 0);
    }

    public Object decode(BytePoolReader reader) {
        return reader.readByte() == 1 ? TRUE : FALSE;
    }

    public String getJavaClassName() {
        return String.class.getName();
    }
}

