/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class LongCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final Long DEFAULT = new Long(0L);
    private static final int WIRE_SIZE = 8;

    public LongCoder() {
        this(DEFAULT);
    }

    protected LongCoder(Object defaultValue) {
        super(defaultValue, 8);
    }

    public int getBrokerType() {
        return 8;
    }

    public int getCoderType() {
        return 1;
    }

    public void encode(BytePoolWriter writer, Object data) {
        writer.writeLong((Long)data);
    }

    public Object decode(BytePoolReader reader) {
        return new Long(reader.readLong());
    }

    public String getJavaClassName() {
        return Long.class.getName();
    }
}

