/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class LegacyStringCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final String DEFAULT = new String();
    private static final int WIRE_SIZE = 4;

    public int getBrokerType() {
        return 65;
    }

    public int getCoderType() {
        return 1;
    }

    public LegacyStringCoder() {
        super(DEFAULT, 4);
    }

    public void encode(BytePoolWriter writer, Object data) {
        writer.startStringValue();
        char[] c = ((String)data).toCharArray();
        byte[] bytes = new byte[c.length];
        for (int i = 0; i < c.length; ++i) {
            if (c[i] > '\u00ff') {
                c[i] = 95;
            }
            bytes[i] = (byte)c[i];
        }
        writer.write(bytes);
        writer.endStringValue();
    }

    public Object decode(BytePoolReader reader) {
        char[] characters = new char[reader.readInt() - 4];
        for (int i = 0; i < characters.length; ++i) {
            characters[i] = (char)reader.readByte();
        }
        int transitPosition = characters.length % 4;
        if (transitPosition != 0) {
            reader.skip(4 - transitPosition);
        }
        return new String(characters);
    }

    public String getJavaClassName() {
        return String.class.getName();
    }
}

