/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class LegacyCharacterCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final String DEFAULT = new String(new char[]{'\u0000'});
    private static final int WIRE_SIZE = 1;

    public int getBrokerType() {
        return 49;
    }

    public int getCoderType() {
        return 1;
    }

    public LegacyCharacterCoder() {
        super(DEFAULT, 1);
    }

    public void encode(BytePoolWriter writer, Object data) {
        int c = ((String)data).charAt(0);
        if (c > 255) {
            c = 95;
        }
        writer.writeByte((byte)c);
    }

    public Object decode(BytePoolReader reader) {
        char[] chars = new char[]{(char)reader.readByte()};
        return new String(chars);
    }

    public String getJavaClassName() {
        return String.class.getName();
    }
}

