/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class IntegerCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final Integer DEFAULT = new Integer(0);
    private static final int WIRE_SIZE = 4;

    public IntegerCoder() {
        this(DEFAULT);
    }

    protected IntegerCoder(Object defaultValue) {
        super(defaultValue, 4);
    }

    public int getBrokerType() {
        return 4;
    }

    public int getCoderType() {
        return 1;
    }

    public void encode(BytePoolWriter writer, Object data) {
        writer.writeInt((Integer)data);
    }

    public Object decode(BytePoolReader reader) {
        return new Integer(reader.readInt());
    }

    public String getJavaClassName() {
        return Integer.class.getName();
    }
}

