/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerDateTypeCoder;
import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class ISO8601Coder
extends BrokerBaseTypeCoder
implements IBrokerDateTypeCoder {
    protected static final char Z = 'Z';
    protected static final char PLUS = '+';
    protected static final char MINUS = '-';
    protected static final char HYPHEN = '-';
    protected static final char DOT = '.';
    protected static final Integer UTC_RAW_OFFSET = new Integer(0);
    protected static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    protected final int YEAR = 0;
    protected final int MONTH = 1;
    protected final int DAY = 2;
    protected final int HOUR = 3;
    protected final int MINUTE = 4;
    protected final int SECOND = 5;
    protected final int MILLISECOND = 6;
    protected static final String STR_COLON = ":";
    protected static final String STR_SEPARATOR = "T";
    protected static final String STR_HYPHEN = "-";
    protected static final String STR_DOT = ".";
    protected static final String STR_Z = "Z";
    protected static final String STR_MINUS = "-";
    protected static final String STR_PLUS = "+";
    protected static final String STR_ZERO = "0";
    private static final Date DEFAULT = new Date();
    private static final int WIRE_SIZE = 8;

    protected static final DateFormat createDateFormatter(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(UTC);
        return df;
    }

    protected ISO8601Coder(Object defaultValue) {
        super(defaultValue, 8);
    }

    private int indexOfTimeZone(Object data) {
        char indicator;
        String dateTime = (String)data;
        int pos = dateTime.length();
        if ((indicator = dateTime.charAt(--pos)) == 'Z') {
            return pos;
        }
        indicator = dateTime.charAt(pos -= 5);
        if (indicator == '+') {
            return pos;
        }
        if (indicator == '-' && dateTime.charAt(pos + 3) != '-') {
            return pos;
        }
        return -1;
    }

    public boolean hasTimeZone(Object data) {
        return this.indexOfTimeZone(data) > -1;
    }

    public Integer retrieveTimeZone(Object data) {
        String dateTime;
        int length;
        if (this._verbose) {
            ISO8601Coder.log("retrieveTimeZone: (data=" + data + ")");
        }
        int index = this.indexOfTimeZone(data);
        if (this._verbose) {
            ISO8601Coder.log("~~~~ found time zone at position " + index + " ~~~~");
        }
        if (index == (length = (dateTime = (String)data).length()) - 1) {
            if (this._verbose) {
                ISO8601Coder.log("~~~~ time zone is Z ~~~~");
            }
            return UTC_RAW_OFFSET;
        }
        char sign = dateTime.charAt(index);
        int hours = 0;
        int minutes = 0;
        try {
            hours = Integer.parseInt(dateTime.substring(index + 1, index + 3));
            minutes = Integer.parseInt(dateTime.substring(index + 4, index + 6));
        }
        catch (NumberFormatException nfe) {
            JournalLogger.log(30, 76, 2, data, STR_ZERO);
        }
        if (this._verbose) {
            ISO8601Coder.log("~~~~ time zone [sign=" + sign + ", hours=" + hours + ", minutes=" + minutes + "] ~~~~");
        }
        int rawoffset = hours * 3600000 + minutes * 60000;
        if (sign == '-') {
            rawoffset = -rawoffset;
        }
        return new Integer(rawoffset);
    }

    protected abstract String format(Calendar var1);

    public int getBrokerType() {
        return 40;
    }

    public int getCoderType() {
        return 2;
    }

    protected void parseTimeInUTC(String data, int startIndex, int[] timespace) {
        try {
            timespace[3] = Integer.parseInt(data.substring(startIndex, startIndex + 2));
            timespace[4] = Integer.parseInt(data.substring(startIndex + 3, startIndex + 5));
            timespace[5] = Integer.parseInt(data.substring(startIndex + 6, startIndex + 8));
            if (data.length() > startIndex + 8 && data.charAt(startIndex + 8) == '.') {
                char end;
                int i;
                int size = data.length();
                for (i = startIndex + 9; i < size && (end = data.charAt(i)) != 'Z' && end != '+' && end != '-'; ++i) {
                }
                timespace[6] = Integer.parseInt(data.substring(startIndex + 9, Math.min(i, startIndex + 9 + 3)));
            }
        }
        catch (NumberFormatException nfe) {
            JournalLogger.log(30, 76, 2, data, STR_ZERO);
        }
    }

    protected int parseDateInUTC(String data, int startIndex, int[] timespace) {
        int yearOffset = data.indexOf(45, 1);
        try {
            timespace[0] = Integer.parseInt(data.substring(startIndex, yearOffset));
            timespace[1] = Integer.parseInt(data.substring(yearOffset + 1, yearOffset + 3));
            timespace[2] = Integer.parseInt(data.substring(yearOffset + 4, yearOffset + 6));
            timespace[1] = timespace[1] - 1;
        }
        catch (NumberFormatException nfe) {
            JournalLogger.log(30, 76, 2, data, STR_ZERO);
        }
        return yearOffset + 6;
    }

    protected Calendar computeCalendarInUTC(int[] timespace) {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.set(1, timespace[0]);
        calendar.set(2, timespace[1]);
        calendar.set(5, timespace[2]);
        calendar.set(11, timespace[3]);
        calendar.set(12, timespace[4]);
        calendar.set(13, timespace[5]);
        calendar.set(14, timespace[6]);
        return calendar;
    }

    public void encode(BytePoolWriter writer, Object data) {
        this.encode(writer, data, UTC_RAW_OFFSET);
    }

    public Object decode(BytePoolReader reader) {
        return this.decode(reader, null);
    }

    public String getJavaClassName() {
        return String.class.getName();
    }

    protected void applyRawOffset(Calendar calendar, Integer timezone) {
        if (this._verbose) {
            ISO8601Coder.log("applyRawOffset: (data=" + this.format(calendar) + ", timezone=" + timezone + ")");
        }
        calendar.add(14, timezone);
    }

    protected String appendTimeZone(String date, Integer timezone) {
        if (this._verbose) {
            ISO8601Coder.log("appendTimeZone: (data=" + date + ", timezone=" + timezone + ")");
        }
        if (timezone.equals(UTC_RAW_OFFSET)) {
            return date + 'Z';
        }
        int rawoffset = timezone;
        boolean isNegative = rawoffset < 0;
        int hours = rawoffset / 3600000;
        int minutes = rawoffset % 3600000 / 60000;
        if (isNegative) {
            hours = -hours;
            minutes = -minutes;
        }
        String dateTZ = date;
        dateTZ = Strings.cat(dateTZ, isNegative ? "-" : STR_PLUS);
        dateTZ = hours < 10 ? Strings.cat(dateTZ, STR_ZERO, Integer.toString(hours)) : Strings.cat(dateTZ, Integer.toString(hours));
        dateTZ = minutes < 10 ? Strings.cat(dateTZ, STR_COLON, STR_ZERO, Integer.toString(minutes)) : Strings.cat(dateTZ, STR_COLON, Integer.toString(minutes));
        return dateTZ;
    }

    protected Calendar _decode(BytePoolReader reader) {
        int[] timespace;
        timespace = new int[]{reader.readShort(), reader.readByte() - 1, reader.readByte(), reader.readByte() & 0x1F, reader.readByte(), reader.readShort(), timespace[5] & 0x3FF};
        timespace[5] = timespace[5] >> 10 & 0x3F;
        return this.computeCalendarInUTC(timespace);
    }

    protected void encodeDateTime(BytePoolWriter writer, int[] timespace, Integer timezone) {
        Calendar calendar = this.computeCalendarInUTC(timespace);
        calendar.add(14, -timezone.intValue());
        if (this._verbose) {
            ISO8601Coder.log("encodDateTime: (data=" + this.format(calendar) + ")");
        }
        short year = (short)calendar.get(1);
        byte month = (byte)calendar.get(2);
        month = (byte)(month + 1);
        byte days = (byte)calendar.get(5);
        byte hours = (byte)calendar.get(11);
        byte minutes = (byte)calendar.get(12);
        short seconds = (byte)calendar.get(13);
        short milliSeconds = (short)calendar.get(14);
        hours = (byte)(hours | 0xA0);
        seconds = (short)(seconds << 10 & 0xFC00);
        seconds = (short)(seconds | milliSeconds);
        writer.writeShort(year);
        writer.writeByte(month);
        writer.writeByte(days);
        writer.writeByte(hours);
        writer.writeByte(minutes);
        writer.writeShort(seconds);
    }
}

