/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GregorianCalendarCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final GregorianCalendar DEFAULT = new GregorianCalendar();
    protected static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    private static final int WIRE_SIZE = 8;

    public GregorianCalendarCoder() {
        super(DEFAULT, 8);
    }

    public int getBrokerType() {
        return 40;
    }

    public int getCoderType() {
        return 1;
    }

    public void encode(BytePoolWriter writer, Object data) {
        GregorianCalendar date = (GregorianCalendar)data;
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date.getTime());
        short year = (short)calendar.get(1);
        byte month = (byte)calendar.get(2);
        month = (byte)(month + 1);
        byte days = (byte)calendar.get(5);
        byte hours = (byte)calendar.get(11);
        byte minutes = (byte)calendar.get(12);
        short seconds = (byte)calendar.get(13);
        short milliSeconds = (short)calendar.get(14);
        hours = (byte)(hours | 0xA0);
        seconds = (short)(seconds << 10 & 0xFC00);
        seconds = (short)(seconds | milliSeconds);
        writer.writeShort(year);
        writer.writeByte(month);
        writer.writeByte(days);
        writer.writeByte(hours);
        writer.writeByte(minutes);
        writer.writeShort(seconds);
    }

    public Object decode(BytePoolReader reader) {
        int year = reader.readShort();
        int month = reader.readByte() - 1;
        int days = reader.readByte();
        int hours = reader.readByte() & 0x1F;
        int minutes = reader.readByte();
        int seconds = reader.readShort();
        int milliSeconds = seconds & 0x3FF;
        seconds = seconds >> 10 & 0x3F;
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, days);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, milliSeconds);
        return calendar;
    }

    public String getJavaClassName() {
        return GregorianCalendar.class.getName();
    }
}

