/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class FloatCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final Float DEFAULT = new Float(0.0f);
    private static final int WIRE_SIZE = 4;

    public FloatCoder() {
        this(DEFAULT);
    }

    protected FloatCoder(Object defaultValue) {
        super(defaultValue, 4);
    }

    public int getBrokerType() {
        return 20;
    }

    public int getCoderType() {
        return 1;
    }

    public void encode(BytePoolWriter writer, Object data) {
        writer.writeInt(Float.floatToIntBits(((Float)data).floatValue()));
    }

    public Object decode(BytePoolReader reader) {
        return new Float(Float.intBitsToFloat(reader.readInt()));
    }

    public String getJavaClassName() {
        return Float.class.getName();
    }
}

